using System;
using System.Collections;
using System.Collections.Specialized;
using System.ComponentModel;
using System.Data;
//using System.Drawing;
//using System.Drawing.Imaging;
using System.IO;
using System.Net;
using System.Text;

using Microsoft.DirectX;
using Microsoft.DirectX.DirectPlay;

namespace LOLGameServer
{
    public class AttachedClient
	{
        #region Static Functions
        public static AttachedClient GetAttachedClientFromUserID(int userID) 
        {
            foreach (AttachedClient __tempClient in Base_GameServer.AttachedClients.Values) 
            {
                if (__tempClient._userID==userID) 
                {
                    return __tempClient;
                }
            }
            return null;
        }
        public static AttachedClient GetAttachedClientFromPlayerID(int playerID) 
        {
            foreach (AttachedClient __tempClient in Base_GameServer.AttachedClients.Values) 
            {
                if (__tempClient._playerID==playerID) 
                {
                    return __tempClient;
                }
            }
            return null;
        }
		public static AttachedClient GetAttachedClientFromUsername(string username) 
		{
			foreach (AttachedClient __tempClient in Base_GameServer.AttachedClients.Values) 
			{
				if (__tempClient.Username==username) 
				{
					return __tempClient;
				}
			}
			return null;
		}
		#endregion

        #region Private Member Variables
        private string _username="";  //This is the player's username in our database
        private int _playerID=0;  //This is the DirectPlay PlayerID
        private int _userID=0;
		private int _xp=0;
		private int _level=0;
        private ClientRole _clientRole;
        private ServerGameInstance _playersGame=null;
        private int _lastRecordedMessageNum=0;
		private bool _isRegisteredUser=true;
        #endregion

        #region Accessor Functions
        public string Username 
        {
            get {return _username;}
        }
        public int PlayerID
        {
            get {return _playerID;}
        }
        public int UserID
        {
            get {return _userID;}
        }
		public int XP 
		{
			get {return _xp;}
		}
		public int Level
		{
			get {return _level;}
		}
		public ServerGameInstance PlayersGame
        {
            get {return _playersGame;}
        }
        public ClientRole ClientRole
        {
            get {return _clientRole;}
        }
        public int LastRecordedMessageNum
        {
            get {return _lastRecordedMessageNum;}
            set {_lastRecordedMessageNum=value;}
        }
		public bool IsRegisteredUser
		{
			get {return _isRegisteredUser;}
		}
		#endregion

        #region Constructor
        //an AttachedClient object is only created when the player actually attaches to the server.
        public AttachedClient(ClientRole clientRole, string username, ServerGameInstance playersGame, int playerID, int userID, int xp, bool isRegisteredUser)
		{
            _clientRole=clientRole;
            _username=username;

            _playersGame=playersGame;  //This is the game instance that the player belongs to.

            _playerID=playerID;   //the DirectPlay PlayerID
            _userID=userID;  //the userID in our DB

			_xp=xp;			
			_level=LobbyServer.PlayerObject.GetLevelFromXP(_xp);

			_isRegisteredUser=isRegisteredUser;
		}
        #endregion

        #region Private Helper Functions
        #endregion

        #region Public Functions
        #endregion

    }
}
