using System;
using System.Collections;

namespace LobbyServer
{
	/// <summary>
	/// Summary description for Class1.
	/// </summary>
	public class ChallengeInfo
	{
        #region Private Static Variables
        public static Hashtable Challenges = new Hashtable();        
        #endregion 

        #region Public Static Functions
        public static bool isPlayerAlreadyBeingChallenged(string playerUsername) 
        {
            ChallengeInfo __tempChallenge;
            foreach (string key in Challenges.Keys) 
            {
                __tempChallenge=(ChallengeInfo) Challenges[key];
                if (__tempChallenge._challengedPlayer.Username.ToLower()==playerUsername.ToLower()) 
                {
                    return true;
                }
            }
            return false;
        }

        public static bool isPlayerAlreadyChallengingSomeone(string playerUsername) 
        {
            foreach (string key in Challenges.Keys) 
            {
                if (key.ToLower()==playerUsername.ToLower()) 
                {
                    return true;
                }
            }
            return false;
        }

        public static PlayerObject GetChallengingPlayerFromChallengedPlayer(string challengedPlayerUsername) 
        {
            ChallengeInfo __tempChallenge;
            foreach (string key in Challenges.Keys) 
            {
                __tempChallenge=(ChallengeInfo) Challenges[key];
                if (__tempChallenge._challengedPlayer.Username.ToLower()==challengedPlayerUsername.ToLower()) 
                {
                    return __tempChallenge.ChallengingPlayer;
                }
            }
            return null;
        }

        public static ChallengeInfo GetChallengeForPlayer(string playerUsername) 
        {
            foreach (ChallengeInfo __challenge in Challenges.Values) 
            {
                if (__challenge._challengedPlayer.Username.ToLower()==playerUsername.ToLower()) 
                {
                    return __challenge;
                }
                if (__challenge._challengingPlayer.Username.ToLower()==playerUsername.ToLower()) 
                {
                    return __challenge;
                }
            }
            return null;
        }
        public static void CancelChallenge (ChallengeInfo challenge) 
        {
            //ChallengeInfo.Challenges.Add(__playerObjectSender.Username.ToLower(),__tempChallengeInfo);        
            ChallengeInfo.Challenges.Remove(challenge._challengingPlayer.Username.ToLower());        
        }
        #endregion

        #region Private Member Variables
        private PlayerObject _challengingPlayer;
        private PlayerObject _challengedPlayer;
        private DateTime _timeChallenged;
        #endregion

        #region Accessor Functions
        public PlayerObject ChallengingPlayer
        {
            get {return _challengingPlayer;}
        }
        public PlayerObject ChallengedPlayer
        {
            get {return _challengedPlayer;}
        }
        public DateTime TimeChallenged 
        {
            get {return _timeChallenged;}
        }

        #endregion

        #region Constructor
        public ChallengeInfo(PlayerObject challengingPlayer, PlayerObject challengedPlayer)
        {
            _challengingPlayer=challengingPlayer;
            _challengedPlayer=challengedPlayer;
            _timeChallenged=DateTime.Now;
        }
        #endregion 

        #region Public Functions
        public bool IsPlayerChallengerInChallenge(string playerUsername) 
        {
            if (_challengingPlayer.Username.ToLower()==playerUsername.ToLower()) 
            {
                return true;
            } 
            else 
            {
                return false;
            }
        }
        #endregion
    }
}
