using System;

/// This is for common networking functions, objects, enums, etc.
public enum GameMessageType
{
    //Login messages
    Login , //Login information
    Logout , //This user wants to log out
    LoginSuccess , //Logged in successfully
    InvalidPassword , //The password for this account is invalid
    InvalidUser , //This user doesn't exist
    UserNotValidated, //This user account hasn't been validated
    LoggedInAlready, // This account has been logged on somewhere else
    OutdatedVersion, // The user is attempting to connect with out outdated version of the client.

    //Game Connect Messages
    GameDoesNotExist,
    InvalidPlayerRole,

    //Game-related messages
    BeginGame, //this is what's used to tell the server that the final setup info is being sent, or the clients that they should switch to the game screen now.
    GameStarted, //this is what tells each client that the other player has attached.
    SendStateString, //this is what's used to tell an attaching client the state of the game (followed by GameState enum)
    GameAction,  //this is what's used to tell all other attached clients in the game about an action by the current player.
    EndTurn,  //this tells the server as well as the the other attached clients that the current player is ending his/her turn
    EndTurnConfirm,  //this tells the server that the recieving player confirms the end-of-turn state.
    PlayerLoggedOff, //this tells the server that a player logged off.
    GameOver, //The game is over for some reason

    //v0.50:
    Rematch, //this message tells the server (and then clients) that a rematch is happening.

    //v0.70:
    MessageConfirmation, //this is used for Client B to tell Client A that it got its message
    DisconnectThisUser, //this is used for the server to disconnect a player -- used to simulate a legitimate disconnect
    PlayerReconnection, //this player has been successfully reconnected after a disconnect.
    PlayerReconnectFailed, //this is used when the player's reconnect attempt has failed (turned down by the server)
    CaughtUpOnResentPackets, //this tells the other client that it is now caught up on all resent packets
    CaughtUpConfirm, //this is sent in response to CaughtUpOnResentPackets
    LastRecievedMessage, //this tells the other client what the last recieved message was

	//v1.20 (show players playing a game, and multiplayer demo.)
	InGamePlayerListLogin,  //this allows LobbyServer to log in to the GameServer and get the player list
	CurrentInGamePlayerList,  //This message is accompanied by a list of current users
	

}


public enum GameOverType 
{
    Victory,
    Error,
    SetupCancel,
    None,
}


public enum ClientRole
{
    None,
    Challenger,
    Challengee,
    Observer,
    CPU
}


public enum GameState 
{
    GameSetup,
    GameInProgress,
    GameOver
}
    
//    public class TH_Networking
//	{
//		public TH_Networking()
//		{
//			//
//			// TODO: Add constructor logic here
//			//
//		}
//	}
