using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.ServiceProcess;
using System.Configuration.Install;
using System.Windows.Forms;
using System.IO;


namespace LOLServices
{
	[RunInstallerAttribute(true)]
	public class LOLServicesInstaller : Installer
	{
		private ServiceInstaller _serviceInstaller;
		private ServiceProcessInstaller _processInstaller;

		public LOLServicesInstaller()
		{
			// Instantiate installers for process and services.
			_processInstaller = new ServiceProcessInstaller();
			_serviceInstaller = new ServiceInstaller();

			// The services run under the system account.
			_processInstaller.Account = ServiceAccount.LocalSystem;

			// The services are started manually.
			_serviceInstaller.StartType = ServiceStartMode.Manual;

			// ServiceName must equal those on ServiceBase derived classes.            
			_serviceInstaller.ServiceName = "LOL Services";

			// Add installers to collection. Order is not important.
			Installers.Add(_serviceInstaller);
			Installers.Add(_processInstaller);
		}
	}

	public class LOLServices : System.ServiceProcess.ServiceBase
	{
		/// <summary> 
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private static StreamWriter _logFile;
		private Base_LobbyServer _lobbyServer;
		private Base_GameServer _gameServer = new Base_GameServer();

		public LOLServices()
		{
			// This call is required by the Windows.Forms Component Designer.
			InitializeComponent();

			// TODO: Add any initialization after the InitComponent call
		}

		// The main entry point for the process
		static void Main()
		{
			System.ServiceProcess.ServiceBase[] ServicesToRun;
	
			// More than one user Service may run within the same process. To add
			// another service to this process, change the following line to
			// create a second service object. For example,
			//
			//   ServicesToRun = New System.ServiceProcess.ServiceBase[] {new LOLServices(), new MySecondUserService()};
			//
			ServicesToRun = new System.ServiceProcess.ServiceBase[] { new LOLServices() };

			System.ServiceProcess.ServiceBase.Run(ServicesToRun);
		}

		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			components = new System.ComponentModel.Container();
			this.ServiceName = "LOL Services";
			this.AutoLog = true;

			if (_logFile == null)
			{
				string __basePath = System.AppDomain.CurrentDomain.DynamicDirectory;
				_logFile = new StreamWriter(__basePath + @"\LOLServices.log", true);
				_logFile.AutoFlush = true;
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if (_logFile != null)
			{
				_logFile.Close();
			}

			if (_lobbyServer != null)
			{
				_lobbyServer.Dispose();
			}

			if (_gameServer != null)
			{
				_gameServer.Dispose();
			}

			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		/// <summary>
		/// Set things in motion so your service can do its work.
		/// </summary>
		protected override void OnStart(string[] args)
		{
			_lobbyServer = new Base_LobbyServer(true);

			if (_lobbyServer != null)
			{
				_logMessage("LobbyServer", "*** START ***");
			}

			_gameServer = new Base_GameServer(true);

			if (_gameServer != null)
			{
				_logMessage("LOLGameServer", "*** START ***");
			}
		}
 
		/// <summary>
		/// Stop this service.
		/// </summary>
		protected override void OnStop()
		{
			_lobbyServer.ShutDown();
			_logMessage("LobbyServer", "*** STOP ***");

			_gameServer.ShutDown();
			_logMessage("LOLGameServer", "*** STOP ***");
		}

		private void _logMessage(string server, string message)
		{
			try
			{
				_logFile.WriteLine("<" + DateTime.Now.ToShortDateString() + 
					" " + DateTime.Now.ToLongTimeString() + 
					", SERVER=" + server + "> " + message);
			}
			catch {}
		}
	}
}
