" Vim Syntax File
" Language:	    Dominions 3 Mod
" Maintainer:	    analytic_kernel (http://forum.shrapnelgames.com/member.php?u=13499)
" Last Change:	    2009/01/24

if exists("b:current_syntax")
    finish
endif

runtime! syntax/dom3_BASE.vim

syntax keyword dom3Cmd_end #end contained
syntax keyword dom3Cmd_selectweapon #selectweapon nextgroup=dom3Either skipwhite skipempty contained
syntax keyword dom3Cmd_newweapon #newweapon nextgroup=dom3Natural skipwhite skipempty contained
syntax keyword dom3Cmd_selectarmor #selectarmor nextgroup=dom3Either skipwhite skipempty contained
syntax keyword dom3Cmd_newarmor #newarmor nextgroup=dom3Natural skipwhite skipempty contained
syntax keyword dom3Cmd_selectmonster #selectmonster nextgroup=dom3Either skipwhite skipempty contained
syntax keyword dom3Cmd_newmonster #newmonster nextgroup=dom3Natural skipwhite skipempty contained
syntax keyword dom3Cmd_selectspell #selectspell nextgroup=dom3Either skipwhite skipempty contained
syntax keyword dom3Cmd_newspell #newspell contained
syntax keyword dom3Cmd_selectitem #selectitem nextgroup=dom3Either skipwhite skipempty contained
syntax keyword dom3Cmd_newitem #newitem contained
syntax keyword dom3Cmd_selectnametype #selectnametype nextgroup=dom3Natural skipwhite skipempty contained
syntax keyword dom3Cmd_selectsite #selectsite nextgroup=dom3Either skipwhite skipempty contained
syntax keyword dom3Cmd_newsite #newsite nextgroup=dom3Natural skipwhite skipempty contained
syntax keyword dom3Cmd_selectnation #selectnation nextgroup=dom3Natural skipwhite skipempty contained

syntax keyword dom3Cmds_String #modname #description #icon #indepflag nextgroup=dom3String skipwhite skipempty
syntax keyword dom3Cmds_Natural #poppergold #resourcemult #supplymult #unresthalfinc #unresthalfres #eventisrare #turmoilincome #turmoilevents #deathincome #deathsupply #deathdeath #slothincome #slothresources #coldincome #coldsupply #misfortune #luckevents #researchscale nextgroup=dom3Natural skipwhite skipempty
syntax keyword dom3Cmds_Version #version #domversion nextgroup=dom3Version skipwhite skipempty

syntax keyword dom3WeaponCmds_String #name nextgroup=dom3String skipwhite skipempty contained
syntax keyword dom3WeaponCmds_Natural #dmg #len #ammo #rcost #aoe #sound #secondaryeffect #secondaryeffectalways #explspr nextgroup=dom3Natural skipwhite skipempty contained
syntax keyword dom3WeaponCmds_Integer #nratt #att #def #range nextgroup=dom3Integer skipwhite skipempty contained
syntax keyword dom3WeaponCmds_Flag #twohanded #armorpiercing #armornegating #magic #dt_normal #dt_stun #dt_paralyze #dt_poison #dt_cap #dt_demon #dt_demononly #dt_holy #dt_magic #dt_small #dt_large #dt_constructonly #dt_raise #mind #cold #fire #shock #poison #bonus #charge #flail #nostr #mrnegates #mrnegateseasily contained
syntax keyword dom3WeaponCmds_NaturalPair #flyspr nextgroup=dom3NaturalPair skipwhite skipempty contained
syntax cluster dom3WeaponCmds contains=dom3Comment,dom3Cmd_end,dom3WeaponCmds_String,dom3WeaponCmds_Natural,dom3WeaponCmds_Integer,dom3WeaponCmds_Flag,dom3WeaponCmds_NaturalPair
syntax region dom3WeaponBlock_Mod start=/#selectweapon/ end=/#end/ fold contains=dom3Cmd_selectweapon,@dom3WeaponCmds keepend
syntax region dom3WeaponBlock_New start=/#newweapon/ end=/#end/ fold contains=dom3Cmd_newweapon,@dom3WeaponCmds keepend

syntax keyword dom3ArmorCmds_String #name nextgroup=dom3String skipwhite skipempty contained
syntax keyword dom3ArmorCmds_Natural #type #prot #enc #rcost nextgroup=dom3Natural skipwhite skipempty contained
syntax keyword dom3ArmorCmds_Integer #def nextgroup=dom3Integer skipwhite skipempty contained
syntax cluster dom3ArmorCmds contains=dom3Comment,dom3Cmd_end,dom3ArmorCmds_String,dom3ArmorCmds_Natural,dom3ArmorCmds_Integer
syntax region dom3ArmorBlock_Mod start=/#selectarmor/ end=/#end/ fold contains=dom3Cmd_selectarmor,@dom3ArmorCmds keepend
syntax region dom3ArmorBlock_New start=/#newarmor/ end=/#end/ fold contains=dom3Cmd_newarmor,@dom3ArmorCmds keepend

syntax keyword dom3MonsterCmds_String #name #spr1 #spr2 #descr #armor nextgroup=dom3String skipwhite skipempty contained
syntax keyword dom3MonsterCmds_Natural #speciallook #ap #mapmove #hp #prot #size #ressize #str #enc #att #def #prec #mr #mor #gcost #rcost #pathcost #startdom #eyes #restrictedgod #darkvision #stealthy #seduce #succubus #beckon #maxage #healer #startaff #coldpower #firepower #stormpower #darkpower #springpower #summerpower #fallpower #winterpower #ambidextrous #berserk #standard #animalawe #awe #fear #regeneration #fireshield #heat #cold #iceprot #poisoncloud #diseasecloud #bloodvengeance #castledef #siegebonus #pillagebonus #researchbonus #forgebonus #douse #nobadevents #spreaddom #leper #itemslots #nametype nextgroup=dom3Natural skipwhite skipempty contained
syntax keyword dom3MonsterCmds_Either #weapon #copystats #copyspr #onebattlespell #firstshape #secondshape #secondtmpshape #shapechange #landshape #watershape #forestshape #plainshape #domsummon #domsummon2 #domsummon20 #makemonster1 #makemonster2 #makemonster5 #summon1 #summon5 nextgroup=dom3Either skipwhite skipempty contained
syntax keyword dom3MonsterCmds_Integer #coldres #fireres #poisonres #shockres #startage #older #supplybonus #reinvigoration #patrolbonus #incunrest nextgroup=dom3Integer skipwhite skipempty contained
syntax keyword dom3MonsterCmds_Flag #clear #clearmagic #clearspec #female #mounted #holy #animal #undead #demon #magicbeing #stonebeing #inanimate #coldblood #immortal #blind #unique #immobile #aquatic #amphibian #pooramphibian #flying #stormimmune #sailing #forestsurvival #mountainsurvival #swampsurvival #wastesurvival #illusion #spy #assassin #heal #noheal #neednoteat #ethereal #trample #entangle #eyeloss #horrormark #poisonarmor #noitem #noleader #poorleader #okleader #goodleader #expertleader #superiorleader #nomagicleader #poormagicleader #okmagicleader #goodmagicleader #expertmagicleader #superiormagicleader #noundeadleader #poorundeadleader #okundeadleader #goodundeadleader #expertundeadleader #superiorundeadleader contained
syntax keyword dom3MonsterCmds_NaturalPair #magicskill #custommagic #gemprod nextgroup=dom3NaturalPair skipwhite skipempty contained
syntax keyword dom3MonsterCmds_NatIntPair #magicboost nextgroup=dom3NatIntPair skipwhite skipempty contained
syntax cluster dom3MonsterCmds contains=dom3Comment,dom3Cmd_end,dom3MonsterCmds_String,dom3MonsterCmds_Natural,dom3MonsterCmds_Either,dom3MonsterCmds_Integer,dom3MonsterCmds_Flag,dom3MonsterCmds_NaturalPair,dom3MonsterCmds_NatIntPair
syntax region dom3MonsterBlock_Mod start=/#selectmonster/ end=/#end/ fold contains=dom3Cmd_selectmonster,@dom3MonsterCmds keepend
syntax region dom3MonsterBlock_New start=/#newmonster/ end=/#end/ fold contains=dom3Cmd_newmonster,@dom3MonsterCmds keepend

syntax keyword dom3SpellCmds_String #name #descr nextgroup=dom3String skipwhite skipempty contained
syntax keyword dom3SpellCmds_Natural #researchlevel #aoe #damage #effect #fatiguecost #flightspr #explspr #nreff #range #sound #spec #restricted nextgroup=dom3Natural skipwhite skipempty contained
syntax keyword dom3SpellCmds_Either #copyspell #nextspell nextgroup=dom3Either skipwhite skipempty contained
syntax keyword dom3SpellCmds_Integer #school #precision nextgroup=dom3Integer skipwhite skipempty contained
syntax keyword dom3SpellCmds_Flag #clear contained
syntax keyword dom3SpellCmds_NaturalPair #pathlevel nextgroup=dom3NaturalPair skipwhite skipempty contained
syntax keyword dom3SpellCmds_NatIntPair #path nextgroup=dom3NatIntPair skipwhite skipempty contained
syntax cluster dom3SpellCmds contains=dom3Comment,dom3Cmd_end,dom3SpellCmds_String,dom3SpellCmds_Natural,dom3SpellCmds_Either,dom3SpellCmds_Integer,dom3SpellCmds_Flag,dom3SpellCmds_NaturalPair,dom3SpellCmds_NatIntPair
syntax region dom3SpellBlock_Mod start=/#selectspell/ end=/#end/ fold contains=dom3Cmd_selectspell,@dom3SpellCmds keepend
syntax region dom3SpellBlock_New start=/#newspell/ end=/#end/ fold contains=dom3Cmd_newspell,@dom3SpellCmds keepend

syntax keyword dom3ItemCmds_String #name #descr #armor nextgroup=dom3String skipwhite skipempty contained
syntax keyword dom3ItemCmds_Natural #constlevel #mainpath #mainlevel #secondarylevel #copyspr #type #weapon nextgroup=dom3Natural skipwhite skipempty contained
syntax keyword dom3ItemCmds_Integer #secondarypath nextgroup=dom3Integer skipwhite skipempty contained
syntax cluster dom3ItemCmds contains=dom3Comment,dom3Cmd_end,dom3ItemCmds_String,dom3ItemCmds_Natural,dom3ItemCmds_Integer
syntax region dom3ItemBlock_Mod start=/#selectitem/ end=/#end/ fold contains=dom3Cmd_selectitem,@dom3ItemCmds keepend
syntax region dom3ItemBlock_New start=/#newitem/ end=/#end/ fold contains=dom3Cmd_newitem,@dom3ItemCmds keepend

syntax keyword dom3NameTypeCmds_String #addname nextgroup=dom3String skipwhite skipempty contained
syntax keyword dom3NameTypeCmds_Flag #clear contained
syntax cluster dom3NameTypeCmds contains=dom3Comment,dom3Cmd_end,dom3NameTypeCmds_String,dom3ItemCmds_Flag
syntax region dom3NameTypeBlock_Mod start=/#selectnametype/ end=/#end/ fold contains=dom3Cmd_selectnametype,@dom3NameTypeCmds keepend

syntax keyword dom3SiteCmds_String #name nextgroup=dom3String skipwhite skipempty contained
syntax keyword dom3SiteCmds_Natural #path #level #rarity #loc #homemon #homecom #mon #com #gold #res #incscale #decscale nextgroup=dom3Natural skipwhite skipempty contained
syntax keyword dom3SiteCmds_Flag #clear contained
syntax keyword dom3SiteCmds_NaturalPair #gems nextgroup=dom3NaturalPair skipwhite skipempty contained
syntax cluster dom3SiteCmds contains=dom3Comment,dom3Cmd_end,dom3SiteCmds_String,dom3SiteCmds_Natural,dom3SiteCmds_Flag,dom3SiteCmds_NaturalPair
syntax region dom3SiteBlock_Mod start=/#selectsite/ end=/#end/ fold contains=dom3Cmd_selectsite,@dom3SiteCmds keepend
syntax region dom3SiteBlock_New start=/#newsite/ end=/#end/ fold contains=dom3Cmd_newsite,@dom3SiteCmds keepend

syntax keyword dom3NationCmds_String #name #epithet #descr #summary #brief #flag #mapbackground nextgroup=dom3String skipwhite skipempty contained
syntax keyword dom3NationCmds_Natural #era #labcost #templecost #templepic #startunitnbrs1 #startunitnbrs2 #defmult1 #defmult1b #defmult2 #defmult2b #castleprod #startfort #defaultfort #farmfort #mountainfort #forestfort #swampfort #uwfort #deepfort nextgroup=dom3Natural skipwhite skipempty contained
syntax keyword dom3NationCmds_Either #startcom #startscout #startunittype1 #startunittype2 #addrecunit #addreccom #defcom1 #defcom2 #defunit1 #defunit1b #defunit2 #defunit2b #startsite nextgroup=dom3Either skipwhite skipempty contained
syntax keyword dom3NationCmds_Integer #hero1 #hero2 #hero3 #hero4 #hero5 #hero6 #multihero1 #multihero2 #idealcold nextgroup=dom3Integer skipwhite skipempty contained
syntax keyword dom3NationCmds_Flag #clearnation #clearrec #clearsites #uwnation #bloodnation #nopreach #dyingdom #sacrificedom #nodeathsupply #domkill #domunrest #autoundead #zombiereanim #horsereanim #wightreanim #manikinreanim #tombwyrmreanim contained
syntax keyword dom3NationCmds_RGBTriplet #color nextgroup=dom3RGBTriplet skipwhite skipempty contained
syntax cluster dom3NationCmds contains=dom3Comment,dom3Cmd_end,dom3NationCmds_String,dom3NationCmds_Natural,dom3NationCmds_Either,dom3NationCmds_Integer,dom3NationCmds_Flag,dom3NationCmds_RGBTriplet
syntax region dom3NationBlock_Mod start=/#selectnation/ end=/#end/ fold contains=dom3Cmd_selectnation,@dom3NationCmds keepend

highlight link dom3Cmd_end			Special
highlight link dom3Cmd_selectweapon		Special
highlight link dom3Cmd_newweapon		Special
highlight link dom3Cmd_selectarmor		Special
highlight link dom3Cmd_newarmor			Special
highlight link dom3Cmd_selectmonster		Special
highlight link dom3Cmd_newmonster		Special
highlight link dom3Cmd_selectspell		Special
highlight link dom3Cmd_newspell			Special
highlight link dom3Cmd_selectitem		Special
highlight link dom3Cmd_newitem			Special
highlight link dom3Cmd_selectnametype		Special
highlight link dom3Cmd_selectsite		Special
highlight link dom3Cmd_newsite			Special
highlight link dom3Cmd_selectnation		Special

highlight link dom3Cmds_String			Keyword
highlight link dom3Cmds_Natural			Keyword
highlight link dom3Cmds_Version			Keyword

highlight link dom3WeaponCmds_String		Keyword
highlight link dom3WeaponCmds_Natural		Keyword
highlight link dom3WeaponCmds_Integer		Keyword
highlight link dom3WeaponCmds_Flag		Keyword
highlight link dom3WeaponCmds_NaturalPair	Keyword

highlight link dom3ArmorCmds_String		Keyword
highlight link dom3ArmorCmds_Natural		Keyword
highlight link dom3ArmorCmds_Integer		Keyword

highlight link dom3MonsterCmds_String		Keyword
highlight link dom3MonsterCmds_Natural		Keyword
highlight link dom3MonsterCmds_Either		Keyword
highlight link dom3MonsterCmds_Integer		Keyword
highlight link dom3MonsterCmds_Flag		Keyword
highlight link dom3MonsterCmds_NaturalPair	Keyword
highlight link dom3MonsterCmds_NatIntPair	Keyword

highlight link dom3SpellCmds_String		Keyword
highlight link dom3SpellCmds_Natural		Keyword
highlight link dom3SpellCmds_Either		Keyword
highlight link dom3SpellCmds_Integer		Keyword
highlight link dom3SpellCmds_Flag		Keyword
highlight link dom3SpellCmds_NaturalPair	Keyword
highlight link dom3SpellCmds_NatIntPair		Keyword

highlight link dom3ItemCmds_String		Keyword
highlight link dom3ItemCmds_Natural		Keyword
highlight link dom3ItemCmds_Integer		Keyword

highlight link dom3NameTypeCmds_String		Keyword
highlight link dom3NameTypeCmds_Flag		Keyword

highlight link dom3SiteCmds_String		Keyword
highlight link dom3SiteCmds_Natural		Keyword
highlight link dom3SiteCmds_Flag		Keyword
highlight link dom3SiteCmds_NaturalPair		Keyword

highlight link dom3NationCmds_String		Keyword
highlight link dom3NationCmds_Natural		Keyword
highlight link dom3NationCmds_Either		Keyword
highlight link dom3NationCmds_Integer		Keyword
highlight link dom3NationCmds_Flag		Keyword
highlight link dom3NationCmds_RGBTriplet	Keyword

let b:current_syntax = "dom3_mod"
syntax sync fromstart
