#!/usr/bin/env python
# -*- Mode: Python; tab-width: 4 -*-

import sys, random
from DMG import D3MNation, D3MSite


def pop_random(list):
    return list.pop(random.randrange(len(list)))
        

def get_features(number = 5):
    feature_list = []
    national_features = ["Cavalry", "Better Magic", "High Priests", "Big Monsters",
                         "Sacred Units", "Crossbows", "Better PD", "Assassins", "Longbows",
                         "Heavy Infantry",
                         ["Lore Master", "Enchantress", "Circle Master", "High Magus",
                          "Warrior Mage", "Wizard", "Sorceress", "Smiths",
                          "Garnet Amazons", "Jade Amazons", "Onyx Amazons", "Crystal Amazons"],
                         ["Hoburgs", "Atavis", "Fir Bolg", "Ichtyids", "Bakemono", "Vaettir"],
                         ["Barbarians", "Bear Tribe", "Deer Tribe", "Wolf Tribe", "Toad Tribe",
                          "Jaguar Tribe", "Horse Tribe", "Lion Tribe"]]

    for x in range(number):
        feature = national_features.pop(random.randrange(len(national_features)))
        if isinstance(feature, list):
            feature = feature.pop(random.randrange(len(feature)))
        feature_list.append(feature)

    return feature_list

def get_magic_paths(number = 3):
    magic_paths = ["Fire",
                   "Air",
                   "Water",
                   "Earth",
                   "Astral",
                   "Nature",
                   "Death",
                   "Blood"]
    paths = []

    for path in range(number):
        paths.append(magic_paths.pop(random.randrange(len(magic_paths))))

    return paths

def get_epithet():
    choice1 = ["Beaten", "Sore", "Bleeding", "Wounded", "Maimed", "Hurt", "Blessed"]
    choice2 = ["Angry", "Vengeful", "Grumpy", "Furious", "Cross", "Pissed", "Joyful"]
    return pop_random(choice1) + " and " + pop_random(choice2)

def create_nation(mod, name, flag = None):
    slot = mod.slot
    description = "Vanquished and exiled from their homeland by invading Pretender Gods, "
    description += "the IndyFunPits have settled here and are determined to survive."
        
    epithet = get_epithet()
    summary = ""
    feature_list = get_features()

    summary += "Features: "
    for feature in feature_list:
        summary += feature + ", "
    summary = summary[:-2] + "  "

    if "Better Magic" in feature_list:
        magic_paths = get_magic_paths(3)
    else:
        magic_paths = get_magic_paths(2)

    summary += "Magic: "
    for path in magic_paths:
        summary += path + ", "
    summary = summary[:-2] 

    IndyFunPits = D3MNation(None, slot, name, epithet, summary, description, summary, flag)
    FunPitPower = D3MSite(800+slot, "FunPit Power " +str(slot))

    base_recruitables = [50,  # slinger
                         17,  # archer
                         ]
    IndyFunPits.add_units(base_recruitables)


    base_commanders = [426,  # scout
                       pop_random([34,35,36]), # one of the commanders
                       240,  # priest
                       ]
    IndyFunPits.add_commanders(base_commanders)

    # Features

    if "High Priests" in feature_list:
        IndyFunPits.add_commanders(241)

    if "Crossbows" in feature_list:
        IndyFunPits.add_units(47)

    if "Longbows" in feature_list:
        IndyFunPits.add_units(55)

    IndyFunPits.add_units(29)  # light infantry

    if "Heavy Infantry" in feature_list:
        units = [38,39,40] 
        IndyFunPits.add_units(pop_random(units))
        IndyFunPits.add_units(pop_random(units))

    if "Hoburgs" in feature_list:
        IndyFunPits.add_units([271,273,1196])
        IndyFunPits.add_commanders(272)

    if "Atavis" in feature_list:
        IndyFunPits.add_units([1118,1121,1122])
        IndyFunPits.add_commanders(1127)

    if "Fir Bolg" in feature_list:
        IndyFunPits.add_units([1758,1749,1756])
        IndyFunPits.add_commanders(1750)

    if "Ichtyids" in feature_list:
        IndyFunPits.add_units([974,975])
        IndyFunPits.add_commanders(976)

    if "Bakemono" in feature_list:
        IndyFunPits.add_units([1394,1395])
        IndyFunPits.add_commanders(1845)

    if "Vaettir" in feature_list:
        IndyFunPits.add_units(541)
        IndyFunPits.add_commanders(913)

    if "Barbarians" in feature_list:
        IndyFunPits.add_units([139,140])
        IndyFunPits.add_commanders(141)

    if "Bear Tribe" in feature_list:
        IndyFunPits.add_units([1592,1593])
        IndyFunPits.add_commanders(1597)

    if "Deer Tribe" in feature_list:
        IndyFunPits.add_units([1594,1595])
        IndyFunPits.add_commanders(1598)

    if "Wolf Tribe" in feature_list:
        IndyFunPits.add_units([123,124])
        IndyFunPits.add_commanders(1596)

    if "Toad Tribe" in feature_list:
        IndyFunPits.add_units(1613)
        IndyFunPits.add_commanders(1614)

    if "Jaguar Tribe" in feature_list:
        IndyFunPits.add_units([1610,1611])
        IndyFunPits.add_commanders(1612)

    if "Horse Tribe" in feature_list:
        IndyFunPits.add_units(137)
        IndyFunPits.add_commanders(136)

    if "Lion Tribe" in feature_list:
        IndyFunPits.add_units([1600,1601])
        IndyFunPits.add_commanders(1602)

    IndyFunPits.add_units(pop_random([24,25,26]))  # light cavalry
        
    if "Cavalry" in feature_list:
        units = [19,20,21,24,25,26,1187] 
        IndyFunPits.add_units(pop_random(units))
        IndyFunPits.add_units(pop_random(units))
        IndyFunPits.add_commanders(pop_random([44,45,46]))
            
    if "Big Monsters" in feature_list:
        units = [518, 447, 150] 
        IndyFunPits.add_units(pop_random(units))

    if "Assassins" in feature_list:
        IndyFunPits.add_commanders(428)

    if "Crystal Amazons" in feature_list:
        FunPitPower.add_commanders([346,347])
        IndyFunPits.add_units(348)
        if "Sacred Units" in feature_list:
            FunPitPower.add_units(367)
    if "Jade Amazons" in feature_list:
        FunPitPower.add_commanders([346,347])
        IndyFunPits.add_units(354)
        if "Sacred Units" in feature_list:
            FunPitPower.add_units(370)
    if "Garnet Amazons" in feature_list:
        FunPitPower.add_commanders([349,350])
        IndyFunPits.add_units(351)
        if "Sacred Units" in feature_list:
            FunPitPower.add_units(612)
    if "Onyx Amazons" in feature_list:
        FunPitPower.add_commanders([355,356])
        IndyFunPits.add_units(357)
        if "Sacred Units" in feature_list:
            FunPitPower.add_units(369)

    if "Sacred Units" in feature_list:
        units = [369,612,370,367]
        FunPitPower.add_units(pop_random(units))

    if "Better PD" in feature_list:
        IndyFunPits.set_PD(34,240,38,55,19)
    else:
        IndyFunPits.set_PD(34,240,29,17,38)

    for path in magic_paths:
        if path == "Fire":
            IndyFunPits.add_commanders(98)
            FunPitPower.add_gems(0,1)
        if path == "Air":
            IndyFunPits.add_commanders(341)
            FunPitPower.add_gems(1,1)
        if path == "Water":
            IndyFunPits.add_commanders(97)
            FunPitPower.add_gems(2,1)
        if path == "Earth":
            IndyFunPits.add_commanders(345)
            FunPitPower.add_gems(3,1)
        if path == "Astral":
            IndyFunPits.add_commanders(478)
            FunPitPower.add_gems(4,1)
        if path == "Death":
            IndyFunPits.add_commanders(310)
            FunPitPower.add_gems(5,1)
        if path == "Nature":
            IndyFunPits.add_commanders(552)
            FunPitPower.add_gems(6,1)
        if path == "Blood":
            IndyFunPits.add_commanders(122)
            FunPitPower.add_gems(7,1)

    if "Smiths" in feature_list:
        FunPitPower.add_commanders(323)
 
    if "Lore Master" in feature_list:
        FunPitPower.add_commanders(479)
            
    if "Enchantress" in feature_list:
        FunPitPower.add_commanders(pop_random([363,364]))
            
    if "Circle Master" in feature_list:
        FunPitPower.add_commanders(122)
            
    if "High Magus" in feature_list:
        FunPitPower.add_commanders(481)
            
    if "Warrior Mage" in feature_list:
        FunPitPower.add_commanders(875)
            
    if "Wizard" in feature_list:
        FunPitPower.add_commanders(pop_random([302,312]))

    if "Sorceress" in feature_list:
        FunPitPower.add_commanders(pop_random([343,344]))
            
    IndyFunPits.add_site(FunPitPower.name)
    IndyFunPits.set_forts(castleprod = 0,
                          startfort = 3,
                          defaultfort = 8,
                          farmfort = 3,
                          forestfort = 33,
                          mountainfort = 36,
                          swampfort = 10)
    mod.add_nation(IndyFunPits)
    mod.add_site(FunPitPower)
