#!/usr/bin/env python
# -*- Mode: Python; tab-width: 4 -*-

from DMG import D3MNation, D3M

def create_nation(mod, nation, flag = None):
    LA_Ulm = D3MNation(None, nation,
                       description = "After years of civil war, the Iron Kingdom crumbled. During the Night of the Treason a great Malediction was placed upon the kingdom. The forests became dark and hostile. Wolves and creatures even worse stalked the land. Slowly the kingdom recovered, but it was not what it once was. The knightly order was all but destroyed and the Master Smiths had disappeared. The secrets of blacksteel were forgotten. An order of Black Priests emerged in Ulm. They formed an Iron Cult and forbade the use of magic. Magic outside religion was announced to be sacrilegious and the few surviving Master Smiths were put to the flames. Although magery is forbidden there are some fortune tellers and members of the Order of the Illuminated Ones who secretly ply their trade in the arcane.",
                       brief = "Ulm is a human kingdom destroyed by civil war and a great curse. Hunger for mortal flesh plagues the nobles of the land. An Iron Inquisition controls the kingdom and all magic is banned. Secretive occultists of the Illuminated Order hide in the shadows and manipulate leaders far and close.",
                       summary = "Race: Stocky humans, production bonus in all castles.  Military: Medium infantry, stealthy rangers, knights, ghoul guardians.  Magic: Astral, Blood, some Earth, Death and Nature, rarely Fire.  Priests: Weak.",
                       epithet = "Black Forest")
    LA_Ulm.add_units([482,1013,1014,1015,1017,1034])
    LA_Ulm.add_commanders([1016,1018,739,740,1023,1012])
    LA_Ulm.set_PD(1016, 739, 1013, 482, 1014)
    LA_Ulm.add_site("The Ruined Keep")
    LA_Ulm.add_site("Black Forest")
    LA_Ulm.add_site("The Black Temple")
    LA_Ulm.set_forts(25, 3, 8, 3, 35, 6, 11)
    LA_Ulm.set_startarmy(1016, 1018, 1013, 8, 1015, 8)
    LA_Ulm.copy_national(spell = "Sanguine Heritage")
    LA_Ulm.copy_national(spell = "Iron Darts")
    LA_Ulm.copy_national(spell = "Iron Blizzard")
    LA_Ulm.copy_national(spell = "Pack of Wolves")
    LA_Ulm.copy_national(spell = "Sloth of Bears")
    LA_Ulm.add_pretenders(mod, [657,215,606,1561,1370,1340,550])
    LA_Ulm.add_heros([1021,1024,1035])
    mod.add_nation(LA_Ulm)

