#! /usr/bin/env python3.0
import os
import sys


print("Script Initializing");

sTemplate="./Research.dm"
sMod="../Research.dm"
sFolder=sys.argv[1];
sName=sys.argv[2];
sGame=sFolder+sName+"/";

print("Mod Template:"+sTemplate);
print("Mod to create:"+sMod);
print("Game to build mod for:"+sName);
print("");


#Reads from the current scoredump file to find out turn number
print("Reading score file");

sScore=sGame+"scores.html"

iTurn=0;
if os.path.exists(sScore):
	with open(sScore, "r") as fScore:
		fScore.readline();
		fScore.readline();
		fScore.readline();
		sTurn=fScore.readline();
		sTurn=sTurn.replace("<title>Dominions 3 Scores, "+sName+" turn ", "")
		sTurn=sTurn.replace("</title>", "")
		if not sTurn.isnumeric:
			exit("some error message");
		iTurn=int(sTurn);
else:
		iTurn=1;

print("Game is at turn "+str(iTurn));
print("");


#Ok, we have the turn, lets do this
print("Creating mod file");

fMod=open(sMod, "w");
fTemplate=open(sTemplate, "r");

iMonster=11514;

if iTurn==1:
	iGold=72;
	iResearch=1;
elif iTurn<=12:
	iGold=74;
	iResearch=13;
elif iTurn<=24:
	iGold=76;
	iResearch=25;
elif iTurn<=36:
	iGold=78;
	iResearch=37;
elif iTurn<=48:
	iGold=80;
	iResearch=49;
else:
	iGold=82;
	iResearch=61;

i=0;
j=0;
while j==0:
	i=i+1;
	sTmp=fTemplate.readline();
	if i>=iMonster+iResearch and i<=iMonster+iResearch+9:
		fMod.write("#");
	if i==iMonster+iGold:
		fMod.write("#");
		iMonster=iMonster+132;
	if iMonster>=14650:
		iMonster=0;
	if sTmp=="":
		break;
	fMod.write(sTmp);

print("Mod file created");

fMod.close();
fTemplate.close();

