/*
 * Decompiled with CFR 0.152.
 */
package com.ap.d3.model.magic;

import com.ap.d3.controller.magic.Grimoire;
import com.ap.d3.fwk.model.IResearch;
import com.ap.d3.model.magic.School;
import com.ap.d3.model.magic.SchoolLevel;
import java.util.HashMap;
import java.util.Map;

public class Research
implements IResearch {
    private Map<School, SchoolLevel> _mapResearch = new HashMap<School, SchoolLevel>();

    public boolean isResearched(String magicSchoolLevelId) {
        SchoolLevel magicSchoolLevel = Grimoire.getGrimoire().getSchoolLevel(magicSchoolLevelId);
        School magicSchool = magicSchoolLevel.getSchool();
        SchoolLevel currentLevel = this._mapResearch.get(magicSchool);
        while (currentLevel.hasRequirement()) {
            if (currentLevel.equals(magicSchoolLevel)) {
                return true;
            }
            currentLevel = currentLevel.getRequirement();
        }
        return currentLevel.equals(magicSchoolLevel);
    }

    public boolean canUpLevel(String magicSchoolId) {
        School magicSchool = Grimoire.getGrimoire().getSchool(magicSchoolId);
        SchoolLevel magicSchoolLevel = this._mapResearch.get(magicSchool);
        return magicSchoolLevel.hasUnlock();
    }

    public void upLevel(String magicSchoolId) {
        School magicSchool = Grimoire.getGrimoire().getSchool(magicSchoolId);
        SchoolLevel magicSchoolLevel = this._mapResearch.get(magicSchool);
        if (magicSchoolLevel.hasUnlock()) {
            this._mapResearch.put(magicSchool, magicSchoolLevel.getUnlock());
        }
    }

    public boolean canDownLevel(String magicSchoolId) {
        School magicSchool = Grimoire.getGrimoire().getSchool(magicSchoolId);
        SchoolLevel magicSchoolLevel = this._mapResearch.get(magicSchool);
        return magicSchoolLevel.hasRequirement();
    }

    public void downLevel(String magicSchoolId) {
        School magicSchool = Grimoire.getGrimoire().getSchool(magicSchoolId);
        SchoolLevel magicSchoolLevel = this._mapResearch.get(magicSchool);
        if (magicSchoolLevel.hasRequirement()) {
            this._mapResearch.put(magicSchool, magicSchoolLevel.getRequirement());
        }
    }

    public SchoolLevel getCurrentLevel(String magicSchoolId) {
        School magicSchool = Grimoire.getGrimoire().getSchool(magicSchoolId);
        return this._mapResearch.get(magicSchool);
    }

    public void setLevel(String magicSchoolId, String magicSchoolLevelId) {
        School magicSchool = Grimoire.getGrimoire().getSchool(magicSchoolId);
        SchoolLevel magicSchoolLevel = Grimoire.getGrimoire().getSchoolLevel(magicSchoolLevelId);
        this._mapResearch.put(magicSchool, magicSchoolLevel);
    }
}

