/*
 * Decompiled with CFR 0.152.
 */
package com.ap.d3.ui.group;

import com.ap.d3.controller.D3Controller;
import com.ap.d3.fwk.model.IResearch;
import com.ap.d3.fwk.model.ISchool;
import com.ap.d3.fwk.model.ISchoolLevel;
import com.ap.d3.ui.D3View;
import com.ap.tools.image.D3ImageCache;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

public class GroupSchool {
    private Group _groupResearch;
    private Map<String, Label> _mapSchool2Label;

    public GroupSchool(Composite parent, int hSpan, int vSpan) {
        this._groupResearch = new Group(parent, 0);
        this._groupResearch.setText("Research Level");
        this._groupResearch.setFont(D3View.FONT_TAHOMA_10_BOLD);
        GridLayout gridLayout = new GridLayout(5, false);
        gridLayout.horizontalSpacing = 2;
        this._groupResearch.setLayout(gridLayout);
        GridData gridData = new GridData(4, 4, true, false);
        this._groupResearch.setLayoutData(gridData);
        this._mapSchool2Label = new HashMap<String, Label>();
        ISchool[] iSchoolArray = D3Controller.getInstance().getGrimoire().getSchools();
        int n = iSchoolArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISchool magicSchool = iSchoolArray[n2];
            final String magicSchoolId = magicSchool.getId();
            Button _buttonHome = this.newButton(this._groupResearch, D3ImageCache.getInstance().getImageUI("bfrewind"));
            Button _buttonMinus = this.newButton(this._groupResearch, D3ImageCache.getInstance().getImageUI("brewind"));
            Button _buttonPlus = this.newButton(this._groupResearch, D3ImageCache.getInstance().getImageUI("bforward"));
            Button _buttonEnd = this.newButton(this._groupResearch, D3ImageCache.getInstance().getImageUI("bfforward"));
            Label label = new Label(this._groupResearch, 4);
            label.setLayoutData(new GridData(16384, 0x1000000, true, false));
            this._mapSchool2Label.put(magicSchoolId, label);
            this.updateLabel(magicSchoolId, false);
            _buttonHome.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    GroupSchool.this.firstLevel(magicSchoolId);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            _buttonMinus.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    GroupSchool.this.downLevel(magicSchoolId);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            _buttonPlus.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    GroupSchool.this.upLevel(magicSchoolId);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            _buttonEnd.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    GroupSchool.this.lastLevel(magicSchoolId);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            ++n2;
        }
        this._groupResearch.pack();
    }

    private Button newButton(Composite parent, Image image) {
        Button button = new Button(parent, 8);
        button.setLayoutData(new GridData(16, 16));
        button.setImage(image);
        return button;
    }

    private void firstLevel(String magicSchoolId) {
        IResearch research = D3Controller.getInstance().getResearch();
        while (research.canDownLevel(magicSchoolId)) {
            research.downLevel(magicSchoolId);
        }
        this.updateLabel(magicSchoolId, true);
    }

    private void downLevel(String magicSchoolId) {
        D3Controller.getInstance().getResearch().downLevel(magicSchoolId);
        this.updateLabel(magicSchoolId, true);
    }

    private void upLevel(String magicSchoolId) {
        D3Controller.getInstance().getResearch().upLevel(magicSchoolId);
        this.updateLabel(magicSchoolId, true);
    }

    private void lastLevel(String magicSchoolId) {
        IResearch research = D3Controller.getInstance().getResearch();
        while (research.canUpLevel(magicSchoolId)) {
            research.upLevel(magicSchoolId);
        }
        this.updateLabel(magicSchoolId, true);
    }

    private void updateLabel(String schoolId, boolean update) {
        ISchoolLevel schoolLevel = D3Controller.getInstance().getResearch().getCurrentLevel(schoolId);
        Label label = this._mapSchool2Label.get(schoolId);
        label.setText("  " + schoolLevel.getName());
        label.pack();
        if (update) {
            D3View.getInstance().changeSchoolFilter(schoolId, schoolLevel);
        }
    }
}

