/*
 * Decompiled with CFR 0.152.
 */
package com.ap.tools.image;

import com.ap.d3.D3Project;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class ImageCache {
    private Map<String, Image> _mapImage = new HashMap<String, Image>();

    ImageCache() {
    }

    public Image getScaledImageMax(String imagePath, int value) {
        Image image = this.getImage(imagePath);
        int iWidth = image.getBounds().width;
        int iHeight = image.getBounds().height;
        if (iWidth > iHeight) {
            if (iWidth == value) {
                return image;
            }
            return this.getScaledImageWidth(imagePath, value);
        }
        if (iHeight == value) {
            return image;
        }
        return this.getScaledImageHeight(imagePath, value);
    }

    public Image getImage(String s) {
        Image result = this._mapImage.get(s);
        if (result == null) {
            ImageDescriptor descriptor = D3Project.getInstance().getFileLoader().getImageDescriptor(s);
            result = descriptor.createImage();
            this._mapImage.put(s, result);
        }
        return result;
    }

    public Image getScaledImageHeight(String s, int height) {
        Image result = this._mapImage.get(String.valueOf(s) + "_H" + height);
        if (result == null) {
            Image originalImage = this.getImage(s);
            int iWidth = originalImage.getBounds().width;
            int iHeight = originalImage.getBounds().height;
            if (iHeight == height) {
                return result;
            }
            int width = iWidth * height / iHeight;
            result = new Image(originalImage.getDevice(), originalImage.getImageData().scaledTo(width, height));
            this._mapImage.put(String.valueOf(s) + "_H" + height, result);
        }
        return result;
    }

    public Image getScaledImageWidth(String s, int width) {
        Image result = this._mapImage.get(String.valueOf(s) + "_W" + width);
        if (result == null) {
            Image originalImage = this.getImage(s);
            int iWidth = originalImage.getBounds().width;
            int iHeight = originalImage.getBounds().height;
            if (iWidth == width) {
                return result;
            }
            int height = iHeight * width / iWidth;
            result = new Image(originalImage.getDevice(), originalImage.getImageData().scaledTo(width, height));
            this._mapImage.put(String.valueOf(s) + "_W" + width, result);
        }
        return result;
    }
}

