#!/usr/bin/env python
# -*- Mode: Python; tab-width: 4 -*-

import sys, random, string
from DMG import D3MNation, D3MSite


def pop_random(list):
    return list.pop(random.randrange(len(list)))
        

def get_magic_paths(number = 2):
    magic_paths = ["Fire",
                   "Air",
                   "Water",
                   "Earth",
                   "Astral",
                   "Nature",
                   "Death",
                   "Blood"]
    paths = []

    for path in range(number):
        paths.append(magic_paths.pop(random.randrange(len(magic_paths))))

    return paths

def get_tribes(number = 3):
    tribes = ["Amazon",
              "Atavi",
              "Fir Bolg",
              "Hoburg",
              "Ichtyid",
              "Human",
              "Raptor",
              "Caveman",
              "Bakemono",
              "Barbarian",
              "Bear",
              "Dear",
              "Horse",
              "Jaguar",
              "Lion",
              "Toad",
              "Wolf",
              "Vaettir",
              "Shamber",
              ]
    tribez = []

    for path in range(number):
        tribez.append(pop_random(tribes))

    return tribez

def get_epithet():
    choice1 = ["Beaten", "Sore", "Bleeding", "Wounded", "Maimed", "Hurt", "Blessed"]
    choice2 = ["Angry", "Vengeful", "Grumpy", "Furious", "Cross", "Pissed", "Joyful"]
    return pop_random(choice1) + " and " + pop_random(choice2)

def create_nation(mod, name, era = 1, flag = None):
    epithet = get_epithet()
    summary = ""
    summary += "Magic: "
    magic_paths = get_magic_paths(2)
    
    for path in magic_paths:
        summary += path + ", "
    summary = summary[:-2] 

    tribes = get_tribes(3)
    name = string.join(tribes) + " Alliance"
    
    description = "Vanquished and exiled from their homeland by invading Pretender Gods, "
    description += "the " + name + " have settled here and are determined to survive."
        
    IndyFunPits = D3MNation(era, name, epithet, summary, description, summary, flag)
    FunPitPower = D3MSite(name)

    base_recruitables = []
    base_commanders = []

    for tribe in tribes:
        if tribe == "Amazon":
            color = pop_random(["Crystal", "Garnet", "Jade", "Onyx"])
            if color == "Crystal":
                base_recruitables += [348, 612]
                base_commanders += [346, 347]
            if color == "Garnet":
                base_recruitables += [351, 612]
                base_commanders += [349, 350]
            if color == "Jade":
                base_recruitables += [354, 370]
                base_commanders += [352, 353]
            if color == "Onyx":
                base_recruitables += [357, 369]
                base_commanders += [355, 356]
        if tribe == "Atavi":
            base_recruitables += [1118,1121,1122]
            base_commanders += [1127]
        if tribe == "Fir Bolg":
            base_recruitables += [1749,1758,1756]
            base_commanders += [1750]
        if tribe == "Hoburg":
            base_recruitables += [273, 483, 1196]
            base_commanders += [272, 1195, 1198]
        if tribe == "Ichtyid":
            base_recruitables += [974, 975]
            base_commanders += [976]
        if tribe == "Human":
            base_recruitables += [17, 29, 39, 26]
            base_commanders += [426, 240, 34]
        if tribe == "Raptor":
            base_recruitables += [205]
            base_commanders += [252]
        if tribe == "Caveman":
            base_recruitables += [1465, 1615]
            base_commanders += [1463, 1616]
        if tribe == "Bakemono":
            base_recruitables += [1394, 1395, 1260]
            base_commanders += [1845, 1609]
        if tribe == "Barbarian":
            base_recruitables += [139,140,1001]
            base_commanders += [141,1002]
        if tribe == "Bear":
            base_recruitables += [1592,1593]
            base_commanders += [1597]
        if tribe == "Dear":
            base_recruitables += [1594,1595]
            base_commanders += [1598]
        if tribe == "Horse":
            base_recruitables += [137]
            base_commanders += [136]
        if tribe == "Jaguar":
            base_recruitables += [1610,1611]
            base_commanders += [1612]
        if tribe == "Lion":
            base_recruitables += [1600,1601]
            base_commanders += [1602]
        if tribe == "Toad":
            base_recruitables += [1613]
            base_commanders += [1614]
        if tribe == "Vaettir":
            base_recruitables += [541]
            base_commanders += [913]
        if tribe == "Shambler":
            base_recruitables += [206]
            base_commanders += [207]
    IndyFunPits.add_units(base_recruitables)
    IndyFunPits.add_commanders(base_commanders)
    IndyFunPits.set_PD(pop_random(base_commanders),
                       pop_random(base_commanders),
                       pop_random(base_recruitables),
                       pop_random(base_recruitables),
                       pop_random(base_recruitables)
                       )    


    for path in magic_paths:
        if path == "Fire":
            IndyFunPits.add_commanders(99)
            FunPitPower.add_gems(0,1)
        if path == "Air":
            IndyFunPits.add_commanders(341)
            FunPitPower.add_gems(1,1)
        if path == "Water":
            IndyFunPits.add_commanders(97)
            FunPitPower.add_gems(2,1)
        if path == "Earth":
            IndyFunPits.add_commanders(325)
            FunPitPower.add_gems(3,1)
        if path == "Astral":
            IndyFunPits.add_commanders(1933)
            FunPitPower.add_gems(4,1)
        if path == "Death":
            IndyFunPits.add_commanders(310)
            FunPitPower.add_gems(5,1)
        if path == "Nature":
            IndyFunPits.add_commanders(552)
            FunPitPower.add_gems(6,1)
        if path == "Blood":
            IndyFunPits.add_commanders(122)
            FunPitPower.add_gems(7,1)
 
    IndyFunPits.add_site(FunPitPower.name)
    IndyFunPits.set_forts(castleprod = 0,
                          startfort = 3,
                          defaultfort = 8,
                          farmfort = 3,
                          forestfort = 33,
                          mountainfort = 36,
                          swampfort = 10)
    mod.add_nation(IndyFunPits)
    mod.add_site(FunPitPower)
