#!/usr/bin/env python
# -*- Mode: Python; tab-width: 4 -*-

from DMG import D3MNation, D3M

def create_nation(mod, nation, flag = None):
    EA_Kailasa = D3MNation(None, nation,
                           brief = "Kailasa is a realm of intelligent apes ruled by Yakshas and Yavanas, divine beings living on the Sacred Mountain of Kailasa.",
                           description = "On the sacred Mount Kailasa, beings from an earlier era still linger.  They are blessed with mystical powers but are few in number.  With the emergence of the new God they have mustered aid from a most unsuspected source.  Deep in the forests below the Sacred Mountain, apes of uncanny brightness have evolved.  The apes are uncivilized and have only recently mastered the mysteries of metal working.",
                           summary = "Race: Yakshas and apes, prefers Heat scale +2.  Military: A multitude of missle weapons and light infantry.  Magic: Water, Earth, Astral, Nature  Priests: Weak",
                           epithet = "Monkey PD is Crank",
                           flag = flag)
    EA_Kailasa.add_units([1118,  # Markata
                          1120,  # Markata Archer
                          1121,  # Atavi Archer
                          1122,  # Atavi Infantry
                          1130,  # Light Bandar Archer
                          1333,  # Bandar Warrior
                          1350,  # Bandar Swordsman
                          1326]) # Guhyaka
    EA_Kailasa.add_commanders([1119,  # Markata Scout 
                               1127,  # Atavi Chieftain
                               1334,  # Bandar Commander
                               1136,  # Yogi
                               1145]) # Guru
    EA_Kailasa.set_PD(defcom1 = 1127,   # Atavi Chieftain
                      defcom2 = 1334,   # Bandar Commander
                      defunit1 = 1118,  # Markata
                      defunit1b = 1120, # Markata Archer
                      defunit2 = 1333,  # Bandar Warrior
                      defunit2b = None,
                      defmult1 = 2,
                      defmult1b = 1.5)
    EA_Kailasa.add_site("Mount Kailasa")
    EA_Kailasa.add_site("The Lotus Garden")
    EA_Kailasa.set_forts(castleprod = 0,
                         startfort = 3,
                         defaultfort = 39,
                         farmfort = 3,
                         forestfort = 33,
                         mountainfort = 36,
                         swampfort = 11)
    EA_Kailasa.set_startarmy(startcom = 1334, # Bandar Commander
                             startscout = 1119, # Markata Scout
                             startunittype1 = 1122, # Atavi Infantry
                             startunitnbrs1 = 15,   
                             startunittype2 = 1120, # Markata Archer
                             startunitnbrs2 = 20)
    EA_Kailasa.add_pretenders(mod,
                              [657,  # Monolith
                               269,  # Wyrm
                               499,  # Nataraja
                               603,  # Father of Serpents
                               606,  # Great Mother
                               979,  # Great White Bull
                               1096, # Destroyer of Worlds
                               1341, # Deva
                               1342, # Mother of Rivers
                               1344, # Lady of Fortune
                               1348])# Mother of Serpents
    EA_Kailasa.add_heros(1585) # Devasura
    mod.add_nation(EA_Kailasa)

