#!/usr/bin/env python
# -*- Mode: Python; tab-width: 4 -*-

from DMG import D3MNation, D3M

def create_nation(mod, nation, flag = None):
    Markatala = D3MNation(None, nation,
                           brief = "A nation of great warriors and unmatched SCs.",
                           description = "Markatala is an ancient empire ruled over by the great King Kong, lord of all monkeys.  How ever, the last King Kong has recently passed away and with no clear successor, the mighty Markata Kings strive to bring all of Markatala under their banners.",
                           summary = "Race: Markata.  Military: Markata soldiers, mages and SCs of unsurpassed ability.  \nMagic: All. \nPriests: Awesome.",
                           epithet = "Age of Ascendance",
                           flag = flag)
    Markatala.add_units([2203,
                         2204,
                         2186])
    Markatala.add_commanders([2205,
                              2200,
                              2201])
    Markatala.set_PD(defcom1 = 2200, 
                      defcom2 = 2201, 
                      defunit1 = 2203,
                      defunit1b = 2186,
                      defunit2 = None, 
                      defunit2b = None,
                      defmult1 = 20,
                      defmult1b = 20)
    Markatala.add_site("Banana Grove")
    Markatala.set_forts(castleprod = 0,
                         startfort = 35,
                         defaultfort = 31,
                         forestfort = 34,
                         mountainfort = 9,
                         swampfort = 11)
    Markatala.set_startarmy(startcom = 2200,
                             startscout = 2205,
                             startunittype1 = 2203
                             startunitnbrs1 = 20,   
                             startunittype2 = 2204, # Markata Archer
                             startunitnbrs2 = 20)
    Markatala.add_heros(1585) # Devasura
    mod.add_nation(Markatala)

