#modname "MA Nation: Avernum, Crystal Souls"
#description "MA Nation: Avernum, Crystal Souls. Based on the Exile series by Spiderweb Software. A nation of Slith lizardmen, Nephil catmen and humans ruled by strange Vahnatai."
#icon "./Avernum/logo.tga"
#version 1.6


---- ORIGINAL MOD AUTHOR AND CREATOR: Sombre
---- (with kind permission from Spiderweb Software for noncommercial usage of 
---- their themes and artwork for the purposes of this mod).

---- CURRENT MAINTAINERS (as of v1.6): Globu and Humakty


----Uses ID numbers

--monsters 2960-96

--weapons 690-695

--sites 990-2

--nametypes 131,132

--nation 72


-- Version 1.6 (changes made by Globu and Humakty)

-- FIX - Avernite Mage and Avernite Captain nametypes fixed. Changed name type of Avernite Archmages to be consistent with those of Avernite Mages.

-- FIX - Avernite Captain's equipment changed to reflect the description's statement that they are equipped the same as their troops.

-- FIX - Avernite Archers and Avernite Captain granted patrol bonus 1 in line with their descriptions and rationale.

-- TWEAK - All Vahnatai Mages and Avernite Archmage magic schemes changed to incorporate random picks.

-- TWEAK - Unit ID numbers moved from 2760-96 to 2960-96 to make for compatibility with CBM and the Lizardmen, Skaven, Bretonnia, Tomb Kings and Wood Elves mods.


-- Version 1.5

-- TWEAK - Vahn ranger greatly reduced in cost

-- TWEAK - Vahn mages and shapers slightly increased in price

-- TWEAK - Avernite mage nerfed a bit

-- TWEAK - Costs of various commaners fine tuned

-- TWEAK - Stealth of Nephil normalised at 10

-- FIX - Moved nametypes to overwrite ea ulm ones, since we've run out and Avernum is an MA nation




-- version 1.4 -- 3.14 is out and I'm updating to follow that. The nation name and the filename of the dm have changed.

-- Darkvision! Avernites get 50, vahns get 50, nephils get 75, slith get 75, trogs get 75

-- Added onebattlespell of northern light to the crystal souls and pretender, plus research bonus

-- Sorted out nametypes

-- redid graphic for avernite captain

-- added patrolbonus to avernite guardsmen



-- version 1.3 -- Many, many tweaks and changes. It has been a while since I updated Avernum and since then I've learned more about modding and balance.

-- Added a 20 gold nephil scout.

-- Fixed a couple of mapmoves.



-------- New Weapons


#newweapon 690
#name "Waveblade"
#dmg 5
#att 3
#def 2
#len 2
#sound 8
#rcost 9
#armorpiercing
#end


#newweapon 691
#name "Slith Trident"
#dmg 8
#att 1
#def 0
#len 4
#sound 12
#rcost 6
#armorpiercing
#magic
#end


#newweapon 692
#name "Great Waveblade"
#dmg 8
#att 3
#def 1
#len 3
#sound 8
#rcost 11
#armorpiercing
#twohanded
#end

#newweapon 693
#name "Warrior Shuriken"
#dmg 10
#att 2
#def 0
#len 0
#range 12
#ammo 2
#nratt 2
#nostr
#sound 19
#flyspr 111 1
#rcost 3
#armorpiercing
#end

#newweapon 694
#name "Ranger Shuriken"
#dmg 10
#att 3
#def 0
#len 0
#range 14
#ammo 4
#nratt 2
#nostr
#sound 19
#flyspr 111 1
#rcost 5
#armorpiercing
#end

#newweapon 695
#name "Large Meathook"
#dmg 7
#att 1
#def 1
#len 1
#sound 8
#rcost 5
#end



-------- New Soldiers


-- Avernite Guard

#newmonster 2960
#name "Avernite Guard"
#descr "The human guards of Avernum keep the Exile community safe from the perils of the caverns and are often called on to repel invaders from Avernite lands. They are well armoured and equipped but they are unlikely to repel a serious assault without the aid of more specialised troops. The guard are specifically trained as patrol and peacekeeping troops."
#spr1 "./Avernum/Avernum Guard.tga"
#spr2 "./Avernum/Avernum Guard2.tga"
#mapmove 1
#hp 10
#str 10
#enc 3
#att 10
#def 10
#prec 9
#mr 10
#mor 10
#gcost 10
#rcost 1
#weapon "Broad Sword"
#armor "Chain Mail Hauberk"
#armor "Kite Shield"
#armor "Half Helmet"
#nametype 100
#darkvision 50
#patrolbonus 1
#end

-- Avernite Archer

#newmonster 2961
#name "Avernite Archer"
#descr "Decades of fighting warlike and stealthy Nephilim tribes taught the human exiles of Avernum the value of well protected archers. With the races now united under Vahnatai leadership the archers continue to guard Avernite interests and, for missile troops, have a high survival rate. The guard are specifically trained as patrol and peacekeeping troops."
#spr1 "./Avernum/Avernum Archer.tga"
#spr2 "./Avernum/Avernum Archer2.tga"
#mapmove 1
#hp 10
#str 10
#enc 3
#att 9
#def 9
#prec 9
#mr 10
#mor 10
#gcost 10
#rcost 1
#weapon "Short bow"
#weapon "short sword"
#armor "Chain Mail Hauberk"
#armor "half helmet"
#nametype 100
#darkvision 50
#patrolbonus 1
--Globu modification: Patrolbonus added.
#end

-- Nephil Brave

#newmonster 2962
#maxage 35
#name "Nephil Brave"
#descr "The coming of the Vahnatai united Slith, Nephilim and Avernite in a way none thought possible. Those grey Nephilim who feel they have something to prove often take the path of the brave. These warriors shun armour and lack the physical strength of Slith or human but make up for it with their speed and lightning reflexes. All Nephilim are stealthy, but highly vulnerable to magic."
#spr1 "./Avernum/Nephilim Brave.tga"
#spr2 "./Avernum/Nephilim Brave2.tga"
#ap 15
#mapmove 2
#hp 10
#prot 0
#str 9
#enc 3
#att 11
#def 11
#prec 12
#mr 8
#mor 10
#gcost 9
#rcost 1
#forestsurvival
#weapon "Short Sword"
#weapon 29
#armor "Bronze Cap"
#stealthy 10
#nametype 121
#ambidextrous 2
#darkvision 75
#end

-- Nephil Archer

#newmonster 2963
#maxage 35
#name "Nephil Archer"
#descr "The coming of the Vahnatai united Slith, Nephilim and Avernite in a way none thought possible. Most common grey Nephilim prefer to fight with bows, relying on their keen senses and natural dexterity to slay their enemies from a distance. They make excellent archers that the Avernites are glad to call allies. All Nephilim are stealthy, but highly vulnerable to magic."
#spr1 "./Avernum/Nephilim Archer.tga"
#spr2 "./Avernum/Nephilim Archer2.tga"
#ap 15
#mapmove 2
#hp 10
#prot 0
#str 9
#enc 3
#att 10
#def 11
#prec 13
#mr 8
#mor 9
#gcost 11
#rcost 1
#forestsurvival
#weapon "short bow"
#weapon 29
#stealthy 10
#nametype 121
#ambidextrous 2
#darkvision 75
#end

-- Nephil Warrior

#newmonster 2964
#maxage 35
#size 2
#name "Nephil Warrior"
#descr "The coming of the Vahnatai united Slith, Nephilim and Avernite in a way none thought possible. Nephilim born with reddish fur are marked from birth to be warriors, the most skillful and intelligent of their tribe. They are unusually strong for Nephilim and are ferocious fighters capable of holding their own against the enemy's elite. All Nephilim are stealthy, but highly vulnerable to magic."
#spr1 "./Avernum/Nephilim Warrior.tga"
#spr2 "./Avernum/Nephilim Warrior2.tga"
#ap 15
#mapmove 2
#hp 11
#prot 0
#size 2
#str 10
#enc 3
#att 12
#def 12
#prec 13
#mr 8
#mor 11
#gcost 13
#rcost 1
#forestsurvival
#weapon "broad sword"
#weapon 29
#armor "Leather hauberk"
#armor "Leather cap"
#stealthy 10
#nametype 121
#ambidextrous 2
#darkvision 75
#end

-- Slith Warrior

#newmonster 2965
#name "Slith Warrior"
#descr "The coming of the Vahnatai united Slith, Nephilim and Avernite in a way none thought possible. The slithzerikai are a noble race of cold-blooded lizardlike humanoids who are naturally strong, tough and intelligent, if a little slow to move. Slith warriors favour polearms and are as skilled as they are proud; they are unlikely to break. All Slith can survive underwater, though with some difficulty."
#spr1 "./Avernum/Slith Warrior.tga"
#spr2 "./Avernum/Slith Warrior2.tga"
#maxage 160
#ap 10
#mapmove 1
#hp 15
#prot 7
#size 2
#str 12
#enc 3
#att 11
#def 11
#prec 10
#mr 10
#mor 13
#gcost 14
#rcost 2
#coldblood
#weapon "trident"
#pooramphibian
#poisonres 50
#fireres 25
#nametype 113
#darkvision 75
#end

-- Slith Warborn

#newmonster 2966
#name "Slith Warborn"
#descr "The coming of the Vahnatai united Slith, Nephilim and Avernite in a way none thought possible. Warborn are, as the name implies, Slithzerikai born in the shadow of war. The scholars of Avernum speculate that the birth of these more aggressive slith, identifiable by the bright fins protruding from their scaly hide, was triggered by these times of unprecedented conflict. Armed with heavy axes and protected by a specially crafted breastplate these Slith make truly excellent heavy infantry. The regenerative abilities and increased resistance to fire displayed by Warborn suggests some link with the dreaded Cave Salamanders."
#spr1 "./Avernum/Slith Warborn.tga"
#spr2 "./Avernum/Slith Warborn2.tga"
#ap 10
#mapmove 1
#hp 17
#prot 7
#size 2
#str 13
#enc 3
#att 12
#def 11
#prec 10
#mr 10
#mor 14
#gcost 18
#rcost 1
#coldblood
#weapon "battleaxe"
#armor "plate cuirass"
#maxage 160
#pooramphibian
#regeneration 10
#poisonres 50
#fireres 50
#nametype 113
#darkvision 75
#end

-- Vahnatai Warrior

#newmonster 2967
#name "Vahnatai Warrior"
#descr "Some Vahnatai choose to take up the path of the warrior and channel the magic that comes so naturally to their race into the pursuit of martial perfection. Vahnatai Warriors treat battle with great reverence and have turned the bloody chaos of melee into an art form. Though physically weak and unarmoured their skill with the impossibly sharp Vahnatai waveblades and lethal shuriken allows them to confront both elite troops and powerful beasts. All Vahnatai are sacred to the people of Avernum."
#spr1 "./Avernum/Vahnatai Warrior.tga"
#spr2 "./Avernum/Vahnatai Warrior2.tga"
#ap 14
#mapmove 2
#hp 8
#prot 0
#size 2
#str 9
#enc 3
#att 13
#def 13
#prec 13
#mr 13
#mor 13
#gcost 32
#rcost 1
#weapon "Waveblade"
#weapon "Warrior Shuriken"
#maxage 450
#holy
#nametype 131
#darkvision 50
#end

-- Vahnatai Soulguard

#newmonster 2968
#name "Vahnatai Soulguard"
#descr "Some Vahnatai choose to take up the path of the warrior and channel the magic that comes so naturally to their race into the pursuit of martial perfection. After surface dwellers broke into the Soul Chamber and splintered the greatest of the Crystals some Vahnatai Warriors vowed never to leave their ancestors unguarded again. The Soulguard rarely join battles beyond the chamber, but when they do there is little that can stand in their way. Regular and lengthly meditation, though it greatly slows their travel, allows them to maintain an astral link with the Crystal Souls, strengthening their frail bodies and healing their wounds almost instantly. They are the only Vahnatai strong enough to use the deadly great waveblades."
#spr1 "./Avernum/Vahnatai Soulguard.tga"
#spr2 "./Avernum/Vahnatai Soulguard2.tga"
#ap 14
#mapmove 1
#hp 12
#prot 0
#size 2
#str 11
#enc 2
#att 13
#def 13
#prec 13
#mr 13
#mor 13
#gcost 40
#rcost 1
#weapon "Great Waveblade"
#holy
#regeneration 50
#heal
#maxage 450
#nametype 131
#darkvision 50
#end

-- Hraithe

#newmonster 2969
#name "Hraithe"
#descr "When a Vahnatai's spiritual essence is somehow destroyed or consumed rather than being preserved in a Crystal Soul or allowed to disperse, a Hraithe is born. The powerful and noble Vahnatai essence is replaced by a vacuum which drives the Hraithe to constantly drain energy from living beings. When the infamous Vahnovoi Vernak-Ihrdu consumed the essence of his clan, he also created a legion of deadly Hraithe to do his bidding. When hunting down prey Hraithe use their intrinsic magic to slip between planes of existence, making them hard to strike with mundane weapons."
#spr1 "./Avernum/Hraithe.tga"
#spr2 "./Avernum/Hraithe2.tga"
#ap 14
#mapmove 2
#hp 13
#prot 3
#size 2
#str 11
#enc 3
#att 11
#def 10
#prec 10
#mr 12
#mor 30
#gcost 1
#rcost 1
#neednoteat
#weapon "life drain"
#weapon "claw"
#undead
#nametype 131
#ethereal
#end


-- Basic Trog

#newmonster 2991
#name "Trog"
#descr "Trogs were bred for war by the most powerful Shapers thousands of years ago. When the Shapers entered their centuries long stasis, they magically sealed their loyal army in a great cavern where the Trogs continued to thrive and war with each other. Trogs are aggressive creatures almost as wide as they are tall and extremely heavily built. They make excellent heavy infantry and such is their strength that they have been known to fight barehanded. Trogs aren't picky about what they eat and can live happily on a diet of rocks and soil."
#spr1 "./Avernum/Troglodyte.tga"
#spr2 "./Avernum/Troglodyte2.tga"
#ap 12
#mapmove 2
#prot 5
#hp 24
#size 2
#str 15
#enc 3
#att 11
#def 11
#prec 9
#mr 10
#mor 12
#gcost 1
#weapon "claw"
#armor "leather hauberk"
#armor "leather cap"
#rcost 1
#nametype 101
#neednoteat
#darkvision 75
#end

-- Trog Warrior

#newmonster 2992
#name "Trog Warrior"
#descr "Trogs were bred for war by the most powerful Shapers thousands of years ago. When the Shapers entered their centuries long stasis, they magically sealed their loyal army in a great cavern where the Trogs continued to thrive and war with each other. Trogs are aggressive creatures almost as wide as they are tall and extremely heavily built. They make excellent heavy infantry and such is their strength that they have been known to fight barehanded. Trogs aren't picky about what they eat and can live happily on a diet of rocks and soil."
#spr1 "./Avernum/Troglodyte Warrior.tga"
#spr2 "./Avernum/Troglodyte Warrior2.tga"
#ap 12
#mapmove 2
#prot 5
#hp 24
#size 2
#str 15
#enc 3
#att 11
#def 11
#prec 9
#mr 10
#mor 12
#gcost 1
#armor "ring mail hauberk"
#armor "Half Helmet"
#weapon "broad sword"
#armor "shield"
#rcost 1
#nametype 101
#neednoteat
#darkvision 75
#end

-- Trog Defender

#newmonster 2993
#name "Trog Defender"
#descr "Trog Defenders were an elite group tasked with protecting the Shapers from all many of dangerous creatures. They were sealed away with the rest of their kind and tasked with maintaining the discipline and fighting spirit of their race, should the Shapers ever need them again. The descendants of the original Defenders loyally followed orders for generations and now they finally have the chance, are more than than ready to fulfil their duties as sacred honour guards."
#spr1 "./Avernum/Troglodyte Defender.tga"
#spr2 "./Avernum/Troglodyte Defender2.tga"
#ap 12
#prot 5
#mapmove 2
#hp 27
#size 2
#str 16
#enc 3
#att 13
#def 12
#prec 9
#mr 11
#mor 14
#gcost 1
#holy
#armor "Plate Hauberk"
#armor "half Helmet"
#weapon "Battleaxe"
#armor "shield"
#rcost 1
#nametype 101
#neednoteat
#darkvision 75
#end

-- Trog Lord

#newmonster 2994
#startage 45
#maxage 70
#name "Trog Lord"
#descr "Leaders of the isolated Trog Clans, the Lords are powerful warriors, physically imposing even by Trog standards. Though their loyalty to the Vahnatai has been assured by the diligent defenders, they are often manipulated by the more intelligent and potentially dangerous Khazim."
#spr1 "./Avernum/Troglodyte Lord.tga"
#spr2 "./Avernum/Troglodyte Lord2.tga"
#ap 12
#mapmove 2
#prot 6
#hp 32
#size 2
#str 17
#enc 3
#att 13
#def 13
#prec 9
#mr 11
#mor 14
#gcost 1
#armor "Leather Hauberk"
#armor "Leather cap"
#weapon "Battleaxe"
#rcost 1
#goodleader
#nametype 101
#darkvision 75
#end

-- Trog Shaman

#newmonster 2995
#startage 50
#maxage 120
#name "Troglodyte Shaman"
#descr "Trog Shamans are crude spiritual leaders who perform a similar function to their Nephil counterparts, often influencing which Trog warriors will survive long enough to become Lords. Bereft of the guiding magical influence of the influence of the Vahnatai for so long, the Shamans developed their own somewhat dark form of magic focusing on earth and death."
#spr1 "./Avernum/Troglodyte Shaman.tga"
#spr2 "./Avernum/Troglodyte Shaman2.tga"
#ap 12
#mapmove 2
#prot 5
#hp 24
#size 2
#str 15
#enc 3
#att 10
#def 10
#prec 9
#mr 14
#mor 13
#gcost 1
#weapon "quarterstaff"
#magicskill 3 1
#custommagic 5120 100
#custommagic 5120 100
#custommagic 5120 50
#custommagic 5120 10
#rcost 1
#researchbonus -2
#holy
#poorleader
#nametype 101
#darkvision 75
#end

-- Trog Khazi

#newmonster 2996
#startage 70
#maxage 200
#name "Trog Khazi"
#descr "The Khazim are a feared sect of Trogs who have mastered a path of dark magic previously forbidden by the Vahnatai. They struggle constantly with the Defenders for control of their race and influence over the Lords. They are only gated in by their Vahnatai creators in the direst circumstances as they rival even the Shapers in raw power. Khazim are well versed in magics of earth and blood."
#spr1 "./Avernum/Troglodyte Khazi.tga"
#spr2 "./Avernum/Troglodyte Khazi2.tga"
#ap 12
#mapmove 2
#prot 5
#hp 22
#size 2
#str 15
#enc 3
#att 10
#def 10
#prec 10
#mr 16
#mor 13
#gcost 1
#weapon "dagger"
#magicskill 7 2
#magicskill 3 3
#custommagic 17408 100
#custommagic 17408 10
#rcost 1
#okleader
#nametype 101
#darkvision 75
#end



-------- Commanders

-- Avernite Captain

#newmonster 2970
#name "Avernite Captain"
#descr "Captains of the Avernite Guard are armed identically to their troops and can be relied on to lead their men bravely into the thick of fighting. As veterans of many battles they have earned the respect of their troops and will raise the morale of those around them."
#spr1 "./Avernum/Avernum Captain.tga"
#spr2 "./Avernum/Avernum Captain2.tga"
#ap 12
#mapmove 2
#hp 11
#prot 0
#size 2
#str 10
#enc 3
#att 11
#def 11
#prec 10
#mr 10
#mor 12
#gcost 40
#rcost 1
#weapon "Broad Sword"
--Globu modification: Added helmet and patrolbonus, and changed nametype from 119 to 100 like the other avernite males.
#armor "Chain Mail Hauberk"
#armor "Kite Shield"
#armor "Half Helmet"
#goodleader
#patrolbonus 2
--Globu modification: Patrolbonus added in conformity with the rest of Avernite human troops, given the rationale that captains have the same training and rise from the same troops.
#standard 5
#nametype 100
#older 10
#darkvision 50
#end

-- Nephil Scout

#newmonster 2982
#maxage 35
#size 2
#name "Nephil Scout"
#descr "The coming of the Vahnatai united Slith, Nephilim and Avernite in a way none thought possible. Scout is a position of honour amongst the Nephilim and many Chiefs held the position in their youth. The catlike people employ the same skills they used to safeguard their tribe in gathering intelligence for the nation of Avernum."
#spr1 "./Avernum/Nephilim Brave.tga"
#spr2 "./Avernum/Nephilim Brave2.tga"
#ap 15
#mapmove 2
#hp 10
#prot 0
#str 9
#enc 3
#att 11
#def 11
#prec 12
#mr 8
#mor 10
#gcost 20
#rcost 1
#forestsurvival
#weapon "short sword"
#weapon 29
#armor "bronze cap"
#stealthy 10
#nametype 121
#ambidextrous 2
#noleader
#darkvision 75
#end

-- Nephil Chief

#newmonster 2971
#maxage 40
#name "Nephil Chief"
#descr "The coming of the Vahnatai united Slith, Nephilim and Avernite in a way none thought possible. Nephilim tribes are headed by chiefs who have not only proven themselves in combat but have the favour of the enigmatic black furred Shamans. Nephilim chiefs are not drilled in modern military tactics, but the Shamans are always sure to back crafty and experienced leaders who know the natural strengths of their kind. All Nephilim are stealthy, but highly vulnerable to magic."
#spr1 "./Avernum/Nephilim Chief.tga"
#spr2 "./Avernum/Nephilim Chief2.tga"
#ap 15
#mapmove 2
#hp 11
#prot 0
#size 2
#str 10
#enc 3
#att 12
#def 12
#prec 13
#mr 8
#mor 11
#gcost 35
#rcost 1
#forestsurvival
#weapon "broad sword"
#armor "Leather hauberk"
#armor "Leather cap"
#armor "shield"
#okleader
#stealthy 10
#nametype 121
#ambidextrous 2
#darkvision 75
#end

-- Nephil Shaman

#newmonster 2972
#startage 30
#maxage 55
#name "Nephil Shaman"
#descr "The coming of the Vahnatai united Slith, Nephilim and Avernite in a way none thought possible. All Nephilim born with black fur are destined to become Shamans, sacred spiritual guides of the scattered tribes. Unlike others of their kind they are cold and emotionless, prefer their own company and, most importantly, harbour no fear of magic. All Nephilim Shamans are skilled in the magic of the wilds and many have cultivated other crafts. Some are even willing to dabble in necromancy."
#spr1 "./Avernum/Nephilim Shaman.tga"
#spr2 "./Avernum/Nephilim Shaman2.tga"
#ap 15
#mapmove 2
#hp 11
#prot 0
#size 2
#str 9
#enc 2
#att 10
#def 10
#prec 12
#mr 12
#mor 11
#gcost 110
#rcost 1
#forestsurvival
#weapon "quarterstaff"
#poorleader
#stealthy 10
#custommagic 6528 50
#researchbonus -1
#magicskill 6 1
#magicskill 8 1
#animalawe 1
#holy
#nametype 121
#ambidextrous 2
#darkvision 75
#end

-- Slith Lord

#newmonster 2973
#maxage 160
#name "Slith Lord"
#descr "The coming of the Vahnatai united Slith, Nephilim and Avernite in a way none thought possible. The Slith of Exile are led by Lords of high birth and impressive martial prowess. They are particularly loyal to the Vahnatai and in recognition of this they have been granted magical tridents able to tear through almost any armour."
#spr1 "./Avernum/Slith Lord.tga"
#spr2 "./Avernum/Slith Lord2.tga"
#ap 11
#mapmove 1
#hp 18
#prot 7
#size 2
#str 13
#enc 3
#att 12
#def 12
#prec 10
#mr 11
#mor 15
#gcost 55
#rcost 1
#coldblood
#weapon "Slith trident"
#armor "Plate cuirass"
#goodleader
#poisonres 50
#fireres 25
#pooramphibian
#nametype 113
#darkvision 75
#end

-- Crystal Soul

#newmonster 2974
#name "Crystal Soul"
#descr "The awakened Vahnatai are guided by a chorus of ancient Crystal Souls, constructs of incredible power inhabited by Vahnatai who shed their mortal forms but wished to stay and protect their people in essence. Though confined to the Chamber of Souls, these crystals draw upon eons of arcane knowledge and are extremely powerful mages and priests. The Council of Souls are the true rulers of Exile. In battle the light they emit increases the power of all astral mages."
#spr1 "./Avernum/Crystal Soul.tga"
#spr2 "./Avernum/Crystal Soul2.tga"
#ap 2
#mapmove 0
#hp 30
#prot 22
#size 3
#str 10
#enc 0
#att 5
#def 0
#prec 12
#mr 20
#mor 30
#gcost 400
#rcost 35
#magicskill 4 4
#magicskill 8 3
#neednoteat
#inanimate
#magic
#blind
#researchbonus 4
#immobile
#holy
#nametype 132
#poorleader
#okmagicleader
#itemslots 12288
#maxage 9000
#onebattlespell "Light of the Northern Star"
#end

-- Slith Pyromancer

#newmonster 2975
#startage 100
#maxage 160
#name "Slith Pyromancer"
#descr "The coming of the Vahnatai united Slith, Nephilim and Avernite in a way none thought possible. Slith Pyro and Hydromancers are masters of, respectively, water and fire magic, though both are also adept at the ancestral earth magic of the cave dwelling Slith. They lack the physical prowess of the warrior classes but they more than make up for it with their intelligence and they are regularly adopted by both Nephilim and Avernite forces to deal with opposing infantry or mages. Pyromancers are entirely immune to the effects of fire, but unlike other Slith, cannot enter the water."
#spr1 "./Avernum/Slith Pyromancer.tga"
#spr2 "./Avernum/Slith Pyromancer2.tga"
#ap 10
#mapmove 1
#hp 14
#prot 6
#size 2
#str 11
#enc 3
#att 10
#def 10
#prec 10
#mr 16
#mor 14
#gcost 130
#rcost 1
#coldblood
#weapon "short sword"
#poorleader
#magicskill 0 2
#magicskill 3 1
#fireres 100
#nametype 113
#darkvision 75
#end

-- Slith Hydromancer

#newmonster 2976
#startage 100
#maxage 160
#name "Slith Hydromancer"
#descr "The coming of the Vahnatai united Slith, Nephilim and Avernite in a way none thought possible. Slith Pyro and Hydromancers are masters of, respectively, water and fire magic, though both are also adept at the ancestral earth magic of the cave dwelling Slith. They lack the physical prowess of the warrior classes but they more than make up for it with their intelligence and they are regularly adopted by both Nephilim and Avernite forces to deal with opposing infantry or mages. Hydromancers are immune to all forms of poison and can function equally well in cold provinces or even underwater."
#spr1 "./Avernum/Slith Hydromancer.tga"
#spr2 "./Avernum/Slith Hydromancer2.tga"
#ap 10
#mapmove 1
#hp 14
#prot 6
#size 2
#str 11
#enc 3
#att 10
#def 10
#prec 10
#mr 16
#mor 14
#gcost 130
#rcost 1
#weapon "short sword"
#poorleader
#magicskill 2 2
#magicskill 3 1
#poisonres 100
#amphibian
#nametype 113
#darkvision 75
#end

-- Vahnatai Mage

#newmonster 2977
#startage 100
#maxage 450
#name "Vahnatai Mage"
#descr "On the road to becoming a revered Shaper the Vahnatai must first learn to control their sublimated passion and chaotic tendencies. These young Vahnatai are gifted spellcasters who have augmented their native Astral craft with the raw power and unpredictability of fire and air magic and as such make excellent battle mages. Some may show signs of the transition from the volatile elements to those used by the Shapers. All Vahnatai are physically frail but strongly resistant to magic."
#spr1 "./Avernum/Vahnatai Mage.tga"
#spr2 "./Avernum/Vahnatai Mage2.tga"
#ap 12
#mapmove 2
#hp 8
#prot 0
#size 2
#str 8
#enc 3
#att 10
#def 10
#prec 12
#mr 18
#mor 11
#gcost 240
#rcost 1
#weapon "dagger"
#poorleader
#holy
#magicskill 0 1 -- Fire 1
#magicskill 1 1 -- Air 1
#magicskill 4 1 -- Astral 1
#custommagic 1408 100
#custommagic 1408 100
--Globu modification: Changed custommagic from 384 (AF) to 1408 (FAE)
#nametype 131
#darkvision 50
#end

-- Vahnatai Shaper

#newmonster 2978
#maxage 450
#name "Vahnatai Shaper"
#descr "In ages past the Shapers were numerous and near godlike in power; they shaped entire lands to their will and some legends say could even travel in the realm of the stars, manipulating the heavens. They are now the highest standing members of Vahnatai society, the rulers of Exile and voices of the Crystal Souls. Their power has faded since the time of legends but they are still easily the most powerful priests and mages in Exile and, while they focus on less destructive magics than the Mages, they are truly a force to be reckoned with. All Vahnatai are physically frail but strongly resistant to magic."
#spr1 "./Avernum/Vahnatai Shaper.tga"
#spr2 "./Avernum/Vahnatai Shaper2.tga"
#ap 12
#mapmove 2
#hp 8
#prot 0
#size 2
#str 8
#enc 3
#att 10
#def 10
#prec 12
#mr 19
#mor 11
#gcost 390
#rcost 1
#weapon "quarterstaff"
#armor "crown"
#goodleader
#holy
#researchbonus 1
#magicskill 4 3 -- Astral 3
#magicskill 8 2 -- Holy 2
#magicskill 3 1 -- Earth 2
#magicskill 2 1 -- Water 2
#custommagic 1536 100 -- Water/Earth 100%
#custommagic 1536 100 -- Water/Earth 100%
#custommagic 1920 20 -- Any Element 20%
--Globu modification: Reduced hard-set earth and water paths from 2 to 1 and added random custommagic picks.
#nametype 132
#darkvision 50
#end

-- Vahnatai Ranger

#newmonster 2979
#name "Vahnatai Ranger"
#descr "Some Vahnatai choose to take up the path of the warrior and channel the magic that comes so naturally to their race into the pursuit of martial perfection. The Warriors may relish combat but the Shapers far prefer a solution which reduces the risk of Vahnatai casualties and the Rangers offer that alternative, striking against enemy commanders before they can lead their troops into battle. Their path is regarded as somewhat dishonourable and they are denied use of the traditional waveblade."
#spr1 "./Avernum/Vahnatai Ranger.tga"
#spr2 "./Avernum/Vahnatai Ranger2.tga"
#ap 14
#mapmove 2
#hp 8
#prot 0
#size 2
#str 9
#enc 3
#att 13
#def 14
#prec 15
#mr 13
#mor 13
#gcost 80
#rcost 1
#weapon "Ranger Shuriken"
#weapon "short sword"
#stealthy 15
#assassin
#noleader
#holy
#nametype 131
#maxage 450
#darkvision 50
#end

-- Avernite Mage

#newmonster 2980
#name "Avernite Mage"
#descr "Avernum was founded by exiles and outcasts from the surface world and it is no coincidence that their magical school is populate by female casters. The exclusively female mages of Avernum are as varied in their skill levels as in their focus; they lack both the reliability of Slith casters and the skill of the Vahnatai, but they are trusted and popular amongst the Avernite Guard."
#spr1 "./Avernum/Avernum Mage.tga"
#spr2 "./Avernum/Avernum Mage2.tga"
#ap 10
#mapmove 2
#hp 9
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 10
#prec 10
#mr 14
#mor 10
#gcost 100
#rcost 1
#poorleader
#standard 5
#magicskill 51 1
#custommagic 14208 40
#weapon "Mace"
--Globu modification: nametype changed from 112 (Caelum female) to 119 (misc female)
#nametype 119
#darkvision 50
#end



-------- New Heroes


---Multiheroes

-- Vahnatai High Shaper

#newmonster 2983
#maxage 450
#older -30
#name "Vahnatai High Shaper"
#descr "A handful of Shapers can still recall some of the magic used by their kind in bygone centuries to alter the earth and heavens to their liking. Their power is such that they tend to regard the Crystal Souls as equals rather than masters, pursuing their own enigmatic agenda."
#spr1 "./Avernum/Vahnatai High Shaper.tga"
#spr2 "./Avernum/Vahnatai High Shaper2.tga"
#ap 12
#mapmove 2
#hp 9
#prot 0
#size 2
#str 9
#enc 3
#att 11
#def 11
#prec 13
#mr 20
#mor 14
#gcost 1
#rcost 1
#weapon "Quarterstaff"
#armor "crown"
#goodleader
#holy
#researchbonus 2
#magicskill 4 4 -- Astral 4
#magicskill 2 2 -- Water 2
#magicskill 3 2 -- Earth 2
#magicskill 8 2 -- Holy 2
--Globu modification: Added the custommagic lines.
#custommagic 1536 30 -- WE 100%
#custommagic 1920 30 -- Elemental 50%
#custommagic 1920 30 -- Elemental 50%
#itemslots 31878
#nametype 132
#darkvision 75
#end

-- Avernite Archmage

#newmonster 2984
#name "Avernite Archmage"
#descr "The highest title that may be granted to an Avernite is that of Archmage. These women far outstrip the typical support mages of Avernum and are spellcasters almost on par with the Vahnatai."
#spr1 "./Avernum/Avernum Archmage.tga"
#spr2 "./Avernum/Avernum Archmage2.tga"
#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 10
#prec 11
#mr 17
#mor 12
#gcost 1
#rcost 1
#goodleader
#magicskill 51 2 -- Elemental Random
#magicskill 51 1 -- Elemental random
#magicskill 51 1 -- Elemental Random
--Globu modification: Added the custommagic lines.
#custommagic 1920 50 -- 50% chance of FAWED
#custommagic 1920 50 -- 50% chance of FAWED
#female
#weapon "Quarterstaff"
#itemslots 31878
--Globu modification: Nametype changed from 112 (Caelum female) to 119 (misc female).
#nametype 119
#older -40
#darkvision 75
#end


--Unique Heroes


-- Vernak Ihrdu

#newmonster 2985
#startage 376
#maxage 600
#name "Vahnovoi"
#descr "Vernak-Tel and his small Vahnatai clan chose to rest in a Soul Chamber near the surface, hoping to be the first to re-emerge at the awakening. When a raiding party blasted into the caverns to attack Avernum they unknowingly collapsed the chamber wiping out every member of the clan save Vernak. Awakened prematurely and surrounded by death the trapped and desperate mage turned to forbidden magic and sustained himself by feeding upon the souls of his brethren. When the newly awakened Vahnatai finally freed him it was apparent he was somehow corrupted, but their laws prevented them from harming a fellow Vahnatai. The newly titled Vernak-Ihrdu, as a fallen Vahnatai or Vahnovoi, now pursues his vendetta against the surface world aided by his soulless clan of Hraithes."
#spr1 "./Avernum/Hero Dark Vahnatai.tga"
#spr2 "./Avernum/Hero Dark Vahnatai2.tga"
#ap 14
#mapmove 2
#hp 12
#prot 0
#size 2
#str 11
#enc 3
#att 13
#def 12
#prec 13
#mr 19
#mor 17
#gcost 1
#rcost 1
#weapon "life drain"
#poorleader
#okundeadleader
#magicskill 4 2
#magicskill 5 3
#summon1 2769
#itemslots 31878
#nametype 132
#darkvision 100
#end

-- Voice of the Wild

#newmonster 2986
#startage 17
#maxage 100
#name "Voice of the Wild"
#descr "The Shamans may be enigmatic, but more mysterious still is the Nephil named Greenpaws. Before Greenpaws it was unheard of for a Nephil without black fur, let alone a female, to use magic. The origins of this young and charismatic female are unknown; she merely appeared one year at a major tribal gathering, defeated two experienced Shamans in a magical contest and proclaimed herself saviour of the Nephilim. Greenpaws has extensive knowledge of the Nephilim's past and with her tales of surface forests teeming with proud Nephil warriors she has convinced many to join her quest to return to the surface."
#spr1 "./Avernum/Hero Greenpaws.tga"
#spr2 "./Avernum/Hero Greenpaws2.tga"
#ap 15
#mapmove 2
#hp 11
#prot 0
#size 2
#str 9
#enc 2
#att 11
#def 11
#prec 12
#mr 14
#mor 13
#gcost 1
#rcost 1
#weapon 29
#forestsurvival
#goodleader
#stealthy 10
#magicskill 6 3
#itemslots 31878
#nametype 122
#ambidextrous 2
#darkvision 75
#end

-- Nephil Fencer

#newmonster 2987
#startage 444
#maxage 666
#name "Nephil Fencer"
#descr "Ibar Rashal is an unusually intelligent and flamboyant Nephil warrior who has recently gained fame and a large following amongst the clans for his dueling of brave and chief alike. He is certainly an accomplished swordfighter, though his style is very different from those taught during the traditional Nephil paths of combat. His charisma and power is such that he attracts a constant stream of Nephil warriors who are unaware of his dark secret."
#spr1 "./Avernum/Hero Nephilim Fencer.tga"
#spr2 "./Avernum/Hero Nephilim Fencer2.tga"
#ap 15
#mapmove 2
#hp 17
#prot 0
#size 2
#str 13
#enc 3
#att 14
#def 14
#prec 13
#mr 11
#mor 17
#gcost 1
#rcost 1
#forestsurvival
#goodleader
#standard 8
#summon1 "Nephil Warrior"
#magicskill 0 2
#magicskill 7 2
#magicboost 53 -2
#shapechange 2788
#weapon "katana"
#weapon 29
#armor "Leather hauberk"
#armor "Leather cap"
#stealthy 10
#itemslots 31878
#nametype 140
#demon
#ambidextrous 2
#end

-- Feline Demon

#newmonster 2988
#startage 444
#maxage 666
#name "Feline Demon"
#descr "Ibar Rashal is in reality a demon who was struck down by celestial beings and forced to hide in a great underground cavern. As time passed Ibar's spirit survived by transferring from the body of one muck dwelling beast to another, his power slowly fading. His chance for freedom came when a mortally wounded Nephil dragged himself into the cavern; Ibar was by this time too weak to fully dominate the creature, so he forged a pact, saving the life of the unfortunate warrior and joining their souls for all eternity. He now seeks to lead the Nephil to bloody conquest of the surface."
#spr1 "./Avernum/Hero Feline Demon.tga"
#spr2 "./Avernum/Hero Feline Demon2.tga"
#ap 15
#mapmove 2
#hp 25
#prot 0
#size 2
#str 15
#enc 3
#att 11
#def 11
#prec 11
#mr 16
#mor 20
#gcost 1
#rcost 1
#shapechange 2787
#poorleader
#weapon 29
#weapon 29
#stealthy 0
#magicskill 0 2
#magicskill 7 2
#itemslots 31878
#demon
#fireres 100
#ambidextrous 2
#end

-- Slith Gladiator

#newmonster 2989
#startage 43
#maxage 89
#name "Slith Gladiator"
#descr "The Slith known only as Slitherhooks was captured by surface dwellers at a young age and forced to fight in the arena. Starved and goaded he was turned into a brutal killing machine completely loyal to his masters, or so they thought. When he finally escaped he did not immediately return to the safety of the Slith caves, but spent two more years on the surface hunting down those responsible for his incarceration. He now puts his famous twin meathooks to good use butchering the enemies of Avernum."
#spr1 "./Avernum/Hero Slith Gladiator.tga"
#spr2 "./Avernum/Hero Slith Gladiator2.tga"
#ap 13
#mapmove 2
#hp 25
#prot 9
#size 2
#str 15
#enc 3
#att 15
#def 13
#prec 10
#mr 10
#mor 19
#gcost 1
#rcost 4
#coldblood
#ambidextrous 4
#berserk 3
#regeneration 10
#weapon "Large Meathook"
#weapon "Large Meathook"
#weapon "bite"
#poorleader
#poisonres 70
#fireres 50
#pooramphibian
#itemslots 31878
#nametype 113
#darkvision 75
#end



-------- New Pretender

#newmonster 2990
#name "Splintered Crystal Soul"
#descr "The dormant Vahnatai Crystal Souls were discovered by a raiding party from the surface. Unable to transport this treasure home intact the raiders called upon their mage to shatter the largest of the crystals. The Vahnatai race awoke to find a cavern full of charred foes and their most ancient and powerful crystal splintered and filled with previously unheard of wrath. The collision of ancient Crystal soul and modern battle magic gave birth to a new power amongst the Vahnatai and a new god of all Exile. The divine Crystal Soul generates two astral pearls every month and the light it emits in battle grants power to all astral mages."
#spr1 "./Avernum/Splintered Crystal Soul.tga"
#spr2 "./Avernum/Splintered Crystal Soul2.tga"
#ap 2
#mapmove 0
#hp 50
#prot 20
#size 4
#str 10
#enc 0
#att 5
#def 0
#prec 12
#mr 18
#mor 30
#gcost 50
#rcost 0
#magicskill 4 4
#pathcost 50
#startdom 4
#neednoteat
#inanimate
#gemprod 4 2
#blind
#researchbonus 4
#immobile
#restrictedgod 72
#nametype 132
#goodleader
#goodmagicleader
#itemslots 28672
#onebattlespell "Light of the Northern Star"
#end



---SPELLS


#newspell
#name "Gate Trogs"
#descr "Opens a brief gateway through which common Trogs emerge."
#school 5
#restricted 72
#researchlevel 3
#path 0 4
#path 1 3
#pathlevel 0 2
#pathlevel 1 1
#effect 10001
#fatiguecost 500
#damage 2991
#nreff 8
#end


#newspell
#name "Gate Trog Warriors"
#descr "Opens a larger gateway admitting a force of Trog Warriors."
#school 5
#restricted 72
#researchlevel 4
#path 0 4
#path 1 3
#pathlevel 0 3
#pathlevel 1 2
#effect 10001
#fatiguecost 1000
#damage 2992
#nreff 10
#end


#newspell
#name "Gate Trog Defenders"
#descr "Opens a gateway exclusively to the ranks of the sacred Defenders."
#school 5
#restricted 72
#researchlevel 6
#path 0 4
#path 1 3
#pathlevel 0 3
#pathlevel 1 2
#effect 10001
#fatiguecost 1000
#damage 2993
#nreff 5
#end


#newspell
#name "Gate Trog Lord"
#descr "Allows a Trog Lord, a commander of some standing, to emerge through an astral gateway."
#school 5
#restricted 72
#researchlevel 5
#path 0 4
#path 1 3
#pathlevel 0 3
#pathlevel 1 2
#effect 10021
#fatiguecost 500
#damage 2994
#nreff 1
#end


#newspell
#name "Gate Trog Shaman"
#descr "Allows a Trog Shaman with skill in earth and death magic to emerge through an astral gateway."
#school 5
#restricted 72
#researchlevel 5
#path 0 4
#path 1 3
#pathlevel 0 3
#pathlevel 1 2
#effect 10021
#fatiguecost 600
#damage 2995
#nreff 1
#end


#newspell
#name "Gate Trog Khazi"
#descr "Allows a feared Trog Khazi with skill in earth and blood magic to emerge through an astral gateway."
#school 5
#restricted 72
#researchlevel 6
#path 0 4
#path 1 3
#pathlevel 0 3
#pathlevel 1 2
#effect 10021
#fatiguecost 1800
#damage 2996
#nreff 1
#end


-------- New sites

#newsite 990

#name "Slith Caves"


#path 2
#level 0


#rarity 5

#gems 0 1
#gems 2 1
#end



#newsite 991

#name "Soul Chamber"

#path 4
#level 0

#rarity 5
#gems 3 1

#homecom 2977
#homecom 2978
#homemon 2968
#end

#newsite 992

#name "Crystal Grove"

#path 4
#level 0

#rarity 5

#gems 4 2

#homecom 2974
#end

-------- New Namepools

--Unique Hero names


-- selectnametype 148
-- clear
-- addname "Ibar Rashal"
-- end

-- selectnametype 131
-- clear
-- addname "Slitherhooks"
-- end

-- selectnametype 142
-- clear
-- addname "Greenpaws"
-- end

-- selectnametype 143
-- clear
-- addname "Vernak-Ihrdu"
-- end

--High Vahnatai names

#selectnametype 132
#clear
#addname "Sendar-Bok"
#addname "Tora-Bok"
#addname "Mona-Bok"
#addname "Tesa-Ihrno"
#addname "Volas-Ihrno"
#addname "Merak-Ihrno"
#addname "Talasi-Ihrno"
#addname "Pak-Ihrno"
#addname "Cesa-Ihrno"
#addname "Mara-Ihrno"
#addname "Brasa-Ihrno"
#addname "Morta-Bok"
#addname "Luma-Bok"
#addname "Praga-Ihrno"
#addname "Torra-Ihrno"
#addname "Tanga-Ihrno"
#addname "Jop-Bok"
#addname "Penta-Bok"
#addname "Parso-Ihrno"
#addname "Jolos-Ihrno"
#addname "Maha-Bok"
#addname "Susa-Ihrno"
#end

--Slith names

-- selectnametype 145
-- clear
-- addname "Slaan"
-- addname "Sleethi"
-- addname "Ssersses"
-- addname "Slither"
-- addname "Slassga"
-- addname "Slisskril"
-- addname "Torless"
-- addname "Tlaathi"
-- addname "Whipssnap"
-- addname "Lerssess"
-- addname "Hethlesss"
-- addname "Sssnarssth"
-- addname "Slasshorth"
-- end

--Nephilim names

--selectnametype 146
--clear
--addname "Frrrg"
--addname "Mrrprr"
--addname "Felix"
--addname "Tom"
--addname "Cattus"
--addname "Prrrrgrr"
--addname "Frrrbrr"
--addname "Frrrls"
--addname "Grrrrf"
--addname "Bluetail"
--addname "Longclaw"
--addname "Frrskss"
--addname "Mouse"
--addname "Whiskers"
--addname "Bindclaw"
--addname "Frrpaw"
--addname "Ratbane"
--end

--Vahnatai names

#selectnametype 131
#clear
#addname "Tekora-Tel"
#addname "Ramda-Tel"
#addname "Tesa-Tel"
#addname "Yosa-Tel"
#addname "Braha-Tel"
#addname "Omni-Tel"
#addname "Pak-Tel"
#addname "Cesa-Ka"
#addname "Mara-Ka"
#addname "Brasa-Ka"
#addname "Morta-Ka"
#addname "Torra-Ka"
#addname "Patma-Ka"
#addname "Remako-Ka"
#addname "Tero-Ka"
#addname "Meni-Ka"
#addname "Jorip-Ka"
#addname "Bon-Tel"
#addname "Vana-Ka"
#addname "Mona-Tel"
#addname "Nom-Ka"
#addname "Torga-Ka"
#addname "Peta-Tel"
#end


-------- New nations



#selectnation 72
#clearnation
#clearsites
#name "Avernum"
#epithet "Crystal Souls"
#era 2
#brief "The underground nation of Avernum is ruled by powerful beings called Vahnatai who have united the Slith, Nephil and humans of the underground world in a single cause."
#descr "Avernum is an underground kingdom founded by outcasts and exiles from the surface world. The exiles at first struggled to survive in the face of warlike native Nephilim and Slithzerikai, but eventually began to train armies and school themselves in the way of magic. The three races continued to war with each other until a new cavern was unsealed and the mystical Vahnatai emerged, awakened from their stasis. The Vahnatai quickly ended the conflicts and united the race, promising to lead them back to the surface world they once called home. Now Avernum's fate rests upon an awakening god and powerful new Vahnatai rulers."
#summary "Race: Humans, Slith, Nephilim and Vahnatai. Military: Varied infantry, no cavalry. Tough Trog Infantry Summons. Magic: Varied, mainly Astral and Elemental. Priests: Strong."
#flag "./Avernum/flag.tga"
#startsite "Slith Caves"
#startsite "Soul Chamber"
#startsite "Crystal Grove"
#templepic 17
#color 0.6 0.0 0.9

--Sets what forts they will use.

#startfort 15
#defaultfort 3

#mountainfort 15
#swampfort 11
#forestfort 35




------- Add soldiers

#addrecunit 2960 -- Avernite Guard
#addrecunit 2961 -- Avernite Archer
#addrecunit 2962 -- Nephil Brave
#addrecunit 2963 -- Nephil Archer
#addrecunit 2964 -- Nephil Warrior
#addrecunit 2965 -- Slith Warrior
#addrecunit 2966 -- Slith Warborn
#addrecunit 2967 -- Vahnatai Warrior



------- Add leaders

#addreccom 2982 -- Nephil Scout
#addreccom 2970 -- Avernite Captain
#addreccom 2980 -- Avernite Mage
#addreccom 2971 -- Nephil Chief
#addreccom 2972 -- Nephil Shaman
#addreccom 2973 -- Slith Lord
#addreccom 2975 -- Slith Pyromancer
#addreccom 2976 -- Slith Hydromancer
#addreccom 2979 -- Vahnatai Ranger
--addreccom 2783 -- High Shaper Multihero
--addreccom 2784 -- Archmage Multihero
--addreccom 2785 -- Vahnovoi hero
--addreccom 2786 -- greenpaws nephil hero
--addreccom 2787 -- Feline demon fencer hero
--addreccom 2789 -- slith gladiator hero


------- Province Defence

--Sets the units to be used in province defense.

#defcom1 2970 -- Avernite Captain
#defcom2 2971 -- Nephil Chief
#defunit1 2960 -- Avernite Guard
#defunit1b 2961 -- Avernite Archer
#defunit2 2962 -- Nephil Brave
#defunit2b 2963 -- Nephil Archer


--Sets how many of the units to appear per point.

#defmult1 10
#defmult1b 10

#defmult2 10
#defmult2b 10


------- Hero Settings

#multihero1 2983
#multihero2 2984
#hero1 2985
#hero2 2986
#hero3 2987
#hero4 2989

#idealcold 0


#startcom 2970 -- Avernite Captain
#startunittype1 2960 -- Avernite Guard
#startunitnbrs1 10
#startunittype2 2961 -- Avernite Archer
#startunitnbrs2 10
#startscout 2982 -- Nephil Scout
#end